/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.numbers;

import edu.umn.biomedicus.numbers.BasicNumberType;
import edu.umn.biomedicus.numbers.NumberDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class NumberModel {
    private final Map<String, NumberDefinition> numbers;
    private final Map<String, NumberDefinition> ordinals;
    private final Map<String, NumberDefinition> denominators;

    private NumberModel(Map<String, NumberDefinition> numbers, Map<String, NumberDefinition> ordinals, Map<String, NumberDefinition> denominators) {
        this.numbers = numbers;
        this.ordinals = ordinals;
        this.denominators = denominators;
    }

    public static NumberModel createNumberModel() throws IOException {
        HashMap<String, NumberDefinition> numbers = new HashMap<String, NumberDefinition>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(NumberModel.class.getClassLoader().getResourceAsStream("edu/umn/biomedicus/measures/NRNUM")));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\|");
                String word = split[1];
                BasicNumberType basicNumberType = NumberModel.typeFromString(split[2]);
                int value = basicNumberType == BasicNumberType.MAGNITUDE ? Integer.valueOf(split[5]).intValue() : Integer.valueOf(split[3]).intValue();
                NumberDefinition numberDefinition = new NumberDefinition(value, basicNumberType);
                numbers.put(word, numberDefinition);
            }
        }
        HashMap<String, NumberDefinition> ordinals = new HashMap<String, NumberDefinition>();
        HashMap<String, NumberDefinition> denominators = new HashMap<String, NumberDefinition>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(NumberModel.class.getClassLoader().getResourceAsStream("edu/umn/biomedicus/measures/NRVAR")));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("\\|");
                String word = split[0];
                String types = split[2];
                String norm = split[3];
                NumberDefinition numberDefinition = (NumberDefinition)numbers.get(norm);
                if (types.contains("ordinal")) {
                    ordinals.put(word, numberDefinition);
                }
                if (!types.contains("denominator")) continue;
                denominators.put(word, numberDefinition);
            }
        }
        return new NumberModel(numbers, ordinals, denominators);
    }

    public static NumberModel createNumberModel(Path nrnumPath, Path nrvarPath) throws IOException {
        HashMap<String, NumberDefinition> numbers = new HashMap<String, NumberDefinition>();
        Files.lines(nrnumPath).forEach(line -> {
            String[] split = line.split("\\|");
            String word = split[1];
            BasicNumberType basicNumberType = NumberModel.typeFromString(split[2]);
            int value = basicNumberType == BasicNumberType.MAGNITUDE ? Integer.valueOf(split[5]).intValue() : Integer.valueOf(split[3]).intValue();
            NumberDefinition numberDefinition = new NumberDefinition(value, basicNumberType);
            numbers.put(word, numberDefinition);
        });
        HashMap<String, NumberDefinition> ordinals = new HashMap<String, NumberDefinition>();
        HashMap<String, NumberDefinition> denominators = new HashMap<String, NumberDefinition>();
        Files.lines(nrvarPath).forEach(line -> {
            String[] split = line.split("\\|");
            String word = split[0];
            String types = split[2];
            String norm = split[3];
            NumberDefinition numberDefinition = (NumberDefinition)numbers.get(norm);
            if (types.contains("ordinal")) {
                ordinals.put(word, numberDefinition);
            }
            if (types.contains("denominator")) {
                denominators.put(word, numberDefinition);
            }
        });
        return new NumberModel(numbers, ordinals, denominators);
    }

    @Nullable
    NumberDefinition getNumberDefinition(String word) {
        return this.numbers.get(word.toLowerCase());
    }

    @Nullable
    NumberDefinition getOrdinal(String word) {
        return this.ordinals.get(word.toLowerCase());
    }

    @Nullable
    NumberDefinition getDenominator(String word) {
        return this.denominators.get(word.toLowerCase());
    }

    private static BasicNumberType typeFromString(String st) {
        switch (st) {
            case "unit": {
                return BasicNumberType.UNIT;
            }
            case "teen": {
                return BasicNumberType.TEEN;
            }
            case "decade": {
                return BasicNumberType.DECADE;
            }
            case "magnitude": {
                return BasicNumberType.MAGNITUDE;
            }
        }
        throw new IllegalStateException("Unrecognized number type: " + st);
    }
}

