/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.numbers;

import edu.umn.biomedicus.numbers.CombinedNumberDetector;
import edu.umn.biomedicus.numbers.DecimalNumberAcceptor;
import edu.umn.biomedicus.numbers.EnglishNumeralsAcceptor;
import edu.umn.biomedicus.numbers.FractionNumberDetector;
import edu.umn.biomedicus.numbers.NumberModel;
import java.io.IOException;
import java.nio.file.Path;

public class Numbers {
    private Numbers() {
        throw new UnsupportedOperationException("Instantiation of utility class");
    }

    public static CombinedNumberDetector createNumberDetector(NumberModel numberModel) {
        return new CombinedNumberDetector(new FractionNumberDetector(), EnglishNumeralsAcceptor.create(numberModel));
    }

    public static CombinedNumberDetector createNumberDetector() throws IOException {
        NumberModel numberModel = NumberModel.createNumberModel();
        return new CombinedNumberDetector(new FractionNumberDetector(), EnglishNumeralsAcceptor.create(numberModel));
    }

    public static CombinedNumberDetector createNumberDetector(Path nrnumPath, Path nrvarPath) throws IOException {
        return new CombinedNumberDetector(new FractionNumberDetector(), EnglishNumeralsAcceptor.create(NumberModel.createNumberModel(nrnumPath, nrvarPath)));
    }

    public static DetectorFactory createFactory(Path nrnumPath, Path nrvarPath) throws IOException {
        return new DetectorFactory(NumberModel.createNumberModel(nrnumPath, nrvarPath));
    }

    public static DetectorFactory createFactory() throws IOException {
        return new DetectorFactory(NumberModel.createNumberModel());
    }

    public static class DetectorFactory {
        private final NumberModel numberModel;

        DetectorFactory(NumberModel numberModel) {
            this.numberModel = numberModel;
        }

        public EnglishNumeralsAcceptor createEnglishNumeralsAcceptor() {
            return EnglishNumeralsAcceptor.create(this.numberModel);
        }

        public DecimalNumberAcceptor createDecimalNumberAcceptor() {
            return new DecimalNumberAcceptor();
        }

        public CombinedNumberDetector createCombinedNumberDetector() {
            return new CombinedNumberDetector(new FractionNumberDetector(), this.createEnglishNumeralsAcceptor());
        }

        public FractionNumberDetector createFractionNumberDetector() {
            return new FractionNumberDetector();
        }
    }
}

