/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.nlpengine;

import edu.umn.nlpengine.Span;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000H\u0016J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0000H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0000H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u0000H\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00a8\u0006#"}, d2={"Ledu/umn/nlpengine/TextRange;", "", "endIndex", "", "getEndIndex", "()I", "length", "getLength", "startIndex", "getStartIndex", "checkIndexes", "", "compareLocation", "textRange", "compareStart", "compareTo", "other", "contains", "", "coveredString", "", "string", "coveredText", "", "charSequence", "locationEquals", "offset", "Ledu/umn/nlpengine/Span;", "value", "offsetRightByStartIndex", "requireBounds", "toIntRange", "Lkotlin/ranges/IntRange;", "toSpan", "trim", "nlpengine"})
public interface TextRange
extends Comparable<TextRange> {
    public int getStartIndex();

    public int getEndIndex();

    public int getLength();

    public int length();

    public boolean locationEquals(@NotNull TextRange var1);

    public boolean contains(@NotNull TextRange var1);

    @NotNull
    public CharSequence coveredText(@NotNull CharSequence var1);

    @NotNull
    public String coveredString(@NotNull String var1);

    @NotNull
    public Span trim(@NotNull CharSequence var1);

    public int compareLocation(@NotNull TextRange var1);

    public int compareStart(@NotNull TextRange var1);

    @NotNull
    public Span toSpan();

    @NotNull
    public Span offset(int var1);

    @NotNull
    public Span offsetRightByStartIndex(@NotNull TextRange var1);

    public void checkIndexes();

    @NotNull
    public IntRange toIntRange();

    public void requireBounds(@NotNull CharSequence var1);

    @Override
    public int compareTo(@NotNull TextRange var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static int getLength(TextRange $this) {
            return $this.getEndIndex() - $this.getStartIndex();
        }

        public static int length(TextRange $this) {
            return $this.getLength();
        }

        public static boolean locationEquals(TextRange $this, @NotNull TextRange other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return $this.getStartIndex() == other.getStartIndex() && $this.getEndIndex() == other.getEndIndex();
        }

        public static boolean contains(TextRange $this, @NotNull TextRange other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return $this.getStartIndex() <= other.getStartIndex() && $this.getEndIndex() >= other.getEndIndex();
        }

        @NotNull
        public static CharSequence coveredText(TextRange $this, @NotNull CharSequence charSequence) {
            Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"charSequence");
            return charSequence.subSequence($this.getStartIndex(), $this.getEndIndex());
        }

        @NotNull
        public static String coveredString(TextRange $this, @NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
            String string2 = string;
            int n = $this.getStartIndex();
            int n2 = $this.getEndIndex();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }

        @NotNull
        public static Span trim(TextRange $this, @NotNull CharSequence charSequence) {
            int n;
            int it;
            int index2;
            int n2;
            int it2;
            int index3;
            Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"charSequence");
            $this.requireBounds(charSequence);
            for (index3 = it2 = (n2 = $this.getEndIndex() - 1); index3 > $this.getStartIndex() && Character.isWhitespace(charSequence.charAt(index3)); --index3) {
            }
            int newEnd = index3 + 1;
            for (index2 = it = (n = $this.getStartIndex()); index2 < newEnd && Character.isWhitespace(charSequence.charAt(index2)); ++index2) {
            }
            int newStart = index2;
            return new Span(newStart, newEnd);
        }

        public static int compareLocation(TextRange $this, @NotNull TextRange textRange) {
            Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
            int compare = Intrinsics.compare((int)$this.getStartIndex(), (int)textRange.getStartIndex());
            if (compare != 0) {
                return compare;
            }
            return Intrinsics.compare((int)$this.getEndIndex(), (int)textRange.getEndIndex());
        }

        public static int compareStart(TextRange $this, @NotNull TextRange textRange) {
            Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
            return Intrinsics.compare((int)$this.getStartIndex(), (int)textRange.getStartIndex());
        }

        @NotNull
        public static Span toSpan(TextRange $this) {
            return new Span($this.getStartIndex(), $this.getEndIndex());
        }

        @NotNull
        public static Span offset(TextRange $this, int value) {
            return new Span($this.getStartIndex() + value, $this.getEndIndex() + value);
        }

        @NotNull
        public static Span offsetRightByStartIndex(TextRange $this, @NotNull TextRange textRange) {
            Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
            return new Span($this.getStartIndex() + textRange.getStartIndex(), $this.getEndIndex() + textRange.getStartIndex());
        }

        public static void checkIndexes(TextRange $this) {
            boolean bl;
            boolean bl2 = bl = $this.getStartIndex() >= 0;
            if (!bl) {
                String string = "startIndex: " + $this.getStartIndex() + " less than 0";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            boolean bl3 = bl = $this.getEndIndex() >= $this.getStartIndex();
            if (!bl) {
                String string = "endIndex: " + $this.getEndIndex() + " less than startIndex: " + $this.getStartIndex();
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        @NotNull
        public static IntRange toIntRange(TextRange $this) {
            return new IntRange($this.getStartIndex(), $this.getEndIndex() - 1);
        }

        public static void requireBounds(TextRange $this, @NotNull CharSequence charSequence) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"charSequence");
            boolean bl2 = bl = $this.getStartIndex() <= charSequence.length();
            if (!bl) {
                String string = "startIndex: " + $this.getStartIndex() + " outside char sequence";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            boolean bl3 = bl = $this.getEndIndex() <= charSequence.length();
            if (!bl) {
                String string = "endIndex: " + $this.getEndIndex() + " outside charSequence";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public static int compareTo(TextRange $this, @NotNull TextRange other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return $this.compareLocation(other);
        }
    }
}

