/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import edu.umn.biomedicus.acronym.Acronyms;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProvidedBy(value=Loader.class)
public class AcronymExpansionsModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcronymExpansionsModel.class);
    private final Map<String, Collection<String>> expansions;

    private AcronymExpansionsModel(Map<String, Collection<String>> expansions) {
        this.expansions = expansions;
    }

    @Nullable
    Collection<String> getExpansions(String acronym) {
        return this.expansions.get(acronym);
    }

    public Set<String> getAcronyms() {
        return this.expansions.keySet();
    }

    boolean hasExpansions(String acronym) {
        return this.expansions.containsKey(acronym);
    }

    @Singleton
    static class Loader
    extends DataLoader<AcronymExpansionsModel> {
        private final Path expansionsModelPath;

        @Inject
        Loader(@Setting(value="acronym.expansionsModel.asDataPath") Path expansionsModelPath) {
            this.expansionsModelPath = expansionsModelPath;
        }

        @Override
        protected AcronymExpansionsModel loadModel() throws BiomedicusException {
            LOGGER.info("Loading acronym expansions: {}", (Object)this.expansionsModelPath);
            HashMap<String, List<String>> expansions = new HashMap<String, List<String>>();
            Pattern splitter = Pattern.compile("\\|");
            try (BufferedReader bufferedReader = Files.newBufferedReader(this.expansionsModelPath);){
                String acronym;
                while ((acronym = bufferedReader.readLine()) != null) {
                    String[] acronymExpansions = splitter.split(bufferedReader.readLine());
                    expansions.put(Acronyms.standardAcronymForm(acronym), Arrays.asList(acronymExpansions));
                }
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
            return new AcronymExpansionsModel(expansions);
        }
    }
}

