/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import edu.umn.biomedicus.acronym.AcronymExpansionsModel;
import edu.umn.biomedicus.acronym.AcronymModel;
import edu.umn.biomedicus.acronym.Acronyms;
import edu.umn.biomedicus.acronym.AlignmentModel;
import edu.umn.biomedicus.acronym.RocksDBSenseVectors;
import edu.umn.biomedicus.acronym.SenseVectors;
import edu.umn.biomedicus.acronym.SparseVector;
import edu.umn.biomedicus.acronym.WordVectorSpace;
import edu.umn.biomedicus.acronyms.ScoredSense;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.tuples.Pair;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.serialization.YamlSerialization;
import edu.umn.biomedicus.tokenization.Token;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

@ProvidedBy(value=Loader.class)
class AcronymVectorModel
implements AcronymModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcronymVectorModel.class);
    private final WordVectorSpace wordVectorSpace;
    private final AcronymExpansionsModel acronymExpansionsModel;
    private final SenseVectors senseVectors;
    @Nullable
    private final AlignmentModel alignmentModel;
    private final double cutoffScore;

    AcronymVectorModel(WordVectorSpace wordVectorSpace, SenseVectors senseVectors, AcronymExpansionsModel acronymExpansionsModel, @Nullable AlignmentModel alignmentModel, double cutoffScore) {
        this.acronymExpansionsModel = acronymExpansionsModel;
        this.senseVectors = senseVectors;
        this.wordVectorSpace = wordVectorSpace;
        this.alignmentModel = alignmentModel;
        this.cutoffScore = cutoffScore;
    }

    public Collection<String> getExpansions(Token token) {
        String acronym = Acronyms.standardAcronymForm(token);
        Collection<String> expansions = this.acronymExpansionsModel.getExpansions(acronym);
        if (expansions != null) {
            return expansions;
        }
        return Collections.emptyList();
    }

    public boolean hasAcronym(Token token) {
        String acronym = Acronyms.standardAcronymForm(token);
        return this.acronymExpansionsModel.hasExpansions(acronym);
    }

    @Override
    public List<ScoredSense> findBestSense(List<? extends Token> context, int forThisIndex) {
        SparseVector sparseVector;
        String acronym = Acronyms.standardAcronymForm(context.get(forThisIndex));
        Collection<String> senses = this.acronymExpansionsModel.getExpansions(acronym);
        if (senses == null) {
            senses = this.acronymExpansionsModel.getExpansions(acronym.toUpperCase());
        }
        if (senses == null) {
            senses = this.acronymExpansionsModel.getExpansions(acronym.replace(".", ""));
        }
        if (senses == null) {
            senses = this.acronymExpansionsModel.getExpansions(acronym.toLowerCase());
        }
        if (senses == null && this.alignmentModel != null) {
            senses = this.alignmentModel.findBestLongforms(acronym);
        }
        if (senses == null || senses.size() == 0) {
            return Collections.emptyList();
        }
        if (senses.size() == 1) {
            return Collections.singletonList(new ScoredSense(senses.iterator().next(), 1.0));
        }
        ArrayList<Pair<String, SparseVector>> usableSenses = new ArrayList<Pair<String, SparseVector>>();
        for (String sense : senses) {
            sparseVector = this.senseVectors.get(sense);
            if (sparseVector == null) continue;
            usableSenses.add(Pair.of(sense, sparseVector));
        }
        if (usableSenses.size() == 0 && this.acronymExpansionsModel.hasExpansions(acronym.toUpperCase())) {
            for (String sense : senses) {
                sparseVector = this.senseVectors.get(sense);
                if (sparseVector == null) continue;
                usableSenses.add(Pair.of(sense, sparseVector));
            }
        }
        if (usableSenses.size() == 0) {
            return Collections.emptyList();
        }
        double best = -1.7976931348623157E308;
        String winner = "(unknown)";
        SparseVector vector = this.wordVectorSpace.vectorize(context, forThisIndex);
        for (Pair pair2 : usableSenses) {
            double score = vector.dot((SparseVector)pair2.getSecond());
            if (!(score > best)) continue;
            best = score;
            winner = (String)pair2.first();
        }
        return usableSenses.stream().map(pair -> {
            double score = vector.dot((SparseVector)pair.getSecond());
            return new ScoredSense((String)pair.first(), score);
        }).filter(scored -> scored.getScore() >= this.cutoffScore).sorted(Comparator.comparing(ScoredSense::getScore).reversed()).collect(Collectors.toList());
    }

    @Override
    public void removeWord(String word) {
        Integer ind = this.wordVectorSpace.removeWord(word);
        if (ind != null) {
            this.senseVectors.removeWord(ind);
        }
    }

    @Override
    public void removeWordsExcept(Set<String> wordsToRemove) {
        Set<Integer> removed = this.wordVectorSpace.removeWordsExcept(wordsToRemove);
        removed.remove(null);
        this.senseVectors.removeWords(removed);
    }

    void writeToDirectory(Path outputDir, @Nullable Map<String, SparseVector> senseVectors) throws IOException {
        Yaml yaml = YamlSerialization.createYaml();
        if (this.alignmentModel != null) {
            yaml.dump((Object)this.alignmentModel, (Writer)Files.newBufferedWriter(outputDir.resolve("alignment.yml"), new OpenOption[0]));
        }
        yaml.dump((Object)this.wordVectorSpace, (Writer)Files.newBufferedWriter(outputDir.resolve("vectorSpace.yml"), new OpenOption[0]));
        if (senseVectors != null) {
            RocksDBSenseVectors rocksDBSenseVectors = new RocksDBSenseVectors(outputDir.resolve("senseVectors"), true);
            rocksDBSenseVectors.putAll(senseVectors);
            rocksDBSenseVectors.close();
        }
    }

    @Singleton
    static class Loader
    extends DataLoader<AcronymVectorModel> {
        @Nullable
        private final Provider<AlignmentModel> alignmentModel;
        private final Path vectorSpacePath;
        private final Path senseMapPath;
        private final boolean useAlignment;
        private final Boolean sensesInMemory;
        private final AcronymExpansionsModel expansionsModel;
        private final Double cutoffScore;

        @Inject
        public Loader(@Nullable Provider<AlignmentModel> alignmentModel, @Setting(value="acronym.useAlignment") Boolean useAlignment, @Setting(value="acronym.vector.model.asDataPath") Path vectorSpacePath, @Setting(value="acronym.senseMap.senseVectors.asDataPath") Path senseMapPath, @Setting(value="acronym.senseMap.inMemory") Boolean sensesInMemory, @Setting(value="acronym.cutoffScore") Double cutoffScore, AcronymExpansionsModel expansionsModel) {
            this.alignmentModel = alignmentModel;
            this.useAlignment = useAlignment;
            this.vectorSpacePath = vectorSpacePath;
            this.senseMapPath = senseMapPath;
            this.sensesInMemory = sensesInMemory;
            this.expansionsModel = expansionsModel;
            this.cutoffScore = cutoffScore;
        }

        @Override
        protected AcronymVectorModel loadModel() throws BiomedicusException {
            Yaml yaml = YamlSerialization.createYaml();
            try {
                LOGGER.info("Loading acronym vector space: {}", (Object)this.vectorSpacePath);
                WordVectorSpace wordVectorSpace = (WordVectorSpace)yaml.load((Reader)Files.newBufferedReader(this.vectorSpacePath));
                LOGGER.info("Loading acronym sense map: {}. inMemory = {}", (Object)this.senseMapPath, (Object)this.sensesInMemory);
                SenseVectors senseVectors = new RocksDBSenseVectors(this.senseMapPath, false).inMemory(this.sensesInMemory);
                return new AcronymVectorModel(wordVectorSpace, senseVectors, this.expansionsModel, this.useAlignment ? (AlignmentModel)this.alignmentModel.get() : null, this.cutoffScore);
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
        }
    }
}

