/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import edu.umn.biomedicus.acronym.AcronymExpansionsModel;
import edu.umn.biomedicus.acronym.AcronymVectorModel;
import edu.umn.biomedicus.acronyms.ScoredSense;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.tokenization.Token;
import edu.umn.nlpengine.AbstractTextRange;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AcronymVectorOfflineEvaluation {
    AcronymVectorOfflineEvaluation(Path expansionsModelPath, Path vectorSpacePath, Path senseMapPath, Path dataPath) throws BiomedicusException, IOException {
        String line;
        AcronymExpansionsModel aem = new AcronymExpansionsModel.Loader(expansionsModelPath).loadModel();
        AcronymVectorModel avm = new AcronymVectorModel.Loader(null, false, vectorSpacePath, senseMapPath, true, 0.0, aem).loadModel();
        int correct = 0;
        int total = 0;
        ArrayList<Result> results = new ArrayList<Result>();
        BufferedReader reader = new BufferedReader(new FileReader(dataPath.toFile()));
        while ((line = reader.readLine()) != null) {
            String[] fields = line.split("\\|");
            String acronym = fields[0];
            String expansion = fields[1];
            if (acronym.equals("ITP") || expansion.equals("UNSURED SENSE")) continue;
            if (expansion.equals("GENERAL ENGLISH")) {
                expansion = acronym.toLowerCase();
            }
            int begin = Integer.parseInt(fields[3]);
            int end = Integer.parseInt(fields[4]);
            String contents = fields[6];
            String modifiedContents = contents.substring(0, begin) + " TOKENOFINTEREST " + contents.substring(end);
            ArrayList<SimpleToken> tokenList = new ArrayList<SimpleToken>();
            int tokenOfInterest = 0;
            int i = 0;
            for (String tokText : modifiedContents.split("\\W+")) {
                SimpleToken tok;
                if (tokText.equals("TOKENOFINTEREST")) {
                    tokText = acronym;
                    tok = new SimpleToken(tokText);
                    tokenOfInterest = i;
                } else {
                    tok = new SimpleToken(tokText);
                }
                tokenList.add(tok);
                ++i;
            }
            List<ScoredSense> senses = avm.findBestSense(tokenList, tokenOfInterest);
            if (senses.size() > 0) {
                String hyp = senses.get(0).getSense();
                results.add(new Result(acronym, expansion, hyp));
                if (hyp.equals(expansion)) {
                    ++correct;
                }
                System.out.format("\r%d   %d   %.1f%%           %s     %s                                                         ", total, correct, 100.0 * (double)correct / (double)total, hyp, expansion);
            }
            ++total;
        }
        System.out.println();
        Map<String, List<Result>> resultsByAcronym = AcronymVectorOfflineEvaluation.getResultsByAcronym(results);
        AcronymVectorOfflineEvaluation.printConfusionByAcronym(resultsByAcronym);
        System.out.println(AcronymVectorOfflineEvaluation.accuracyByAcronym(resultsByAcronym));
        System.out.println((double)correct / (double)total);
    }

    public static void main(String[] args) throws BiomedicusException, IOException {
        Path expansionsModelPath = Paths.get(args[0], new String[0]);
        Path vectorSpacePath = Paths.get(args[1], new String[0]);
        Path senseMapPath = Paths.get(args[2], new String[0]);
        Path dataPath = Paths.get(args[3], new String[0]);
        new AcronymVectorOfflineEvaluation(expansionsModelPath, vectorSpacePath, senseMapPath, dataPath);
    }

    static double getAccuracy(Iterable<Result> results) {
        int correct = 0;
        int total = 0;
        for (Result result : results) {
            if (result.isCorrect()) {
                ++correct;
            }
            ++total;
        }
        return (double)correct / (double)total;
    }

    static Map<String, Double> accuracyByAcronym(Map<String, List<Result>> resultsByAcronym) {
        HashMap<String, Double> acrAcc = new HashMap<String, Double>();
        for (Map.Entry<String, List<Result>> e : resultsByAcronym.entrySet()) {
            acrAcc.put(e.getKey(), AcronymVectorOfflineEvaluation.getAccuracy((Iterable<Result>)e.getValue()));
        }
        return acrAcc;
    }

    static void printConfusionByAcronym(Map<String, List<Result>> resultsByAcronym) {
        for (Map.Entry<String, List<Result>> e : resultsByAcronym.entrySet()) {
            int i;
            String acronym = e.getKey();
            System.out.println(acronym);
            List<Result> results = e.getValue();
            HashSet senses = new HashSet();
            results.forEach(result -> {
                senses.add(result.gold);
                senses.add(result.hyp);
            });
            int[][] mat = new int[senses.size()][senses.size()];
            ArrayList listSenses = new ArrayList(senses);
            for (Result result2 : results) {
                int[] nArray = mat[listSenses.indexOf(result2.gold)];
                int n = listSenses.indexOf(result2.hyp);
                nArray[n] = nArray[n] + 1;
            }
            for (i = 0; i < 40; ++i) {
                System.out.print(" ");
            }
            listSenses.forEach(sense -> System.out.print("\t" + sense));
            System.out.println();
            for (i = 0; i < mat.length; ++i) {
                System.out.print((String)listSenses.get(i));
                for (int spaceCount = 0; spaceCount < 40 - ((String)listSenses.get(i)).length(); ++spaceCount) {
                    System.out.print(" ");
                }
                for (int j = 0; j < mat.length; ++j) {
                    System.out.print("\t" + mat[i][j]);
                }
                System.out.println();
            }
        }
    }

    static Map<String, List<Result>> getResultsByAcronym(Iterable<Result> results) {
        LinkedHashMap<String, List<Result>> resultsByAcronym = new LinkedHashMap<String, List<Result>>();
        for (Result result : results) {
            ArrayList<Result> theseResults = (ArrayList<Result>)resultsByAcronym.get(result.acronym);
            if (theseResults == null) {
                theseResults = new ArrayList<Result>();
                resultsByAcronym.put(result.acronym, theseResults);
            }
            theseResults.add(result);
        }
        return resultsByAcronym;
    }

    private class SimpleToken
    extends AbstractTextRange
    implements Token {
        final String text;

        SimpleToken(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public boolean getHasSpaceAfter() {
            return true;
        }

        public int getStartIndex() {
            return 0;
        }

        public int getEndIndex() {
            return 0;
        }
    }

    private static class Result {
        final String acronym;
        final String gold;
        final String hyp;

        Result(String acronym, String gold, String hyp) {
            this.acronym = acronym;
            this.gold = gold;
            this.hyp = hyp;
        }

        boolean isCorrect() {
            return this.gold.equals(this.hyp);
        }
    }
}

