/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import edu.umn.biomedicus.tokenization.Token;
import java.util.regex.Pattern;

public final class Acronyms {
    public static final String UNKNOWN = "(unknown)";
    private static final Pattern SINGLE_DIGIT = Pattern.compile("[0-9]");
    private static final Pattern DECIMAL_NUMBER = Pattern.compile("[0-9]*\\.[0-9]+");
    private static final Pattern BIG_NUMBER = Pattern.compile("[0-9][0-9,]+");

    private Acronyms() {
        throw new UnsupportedOperationException();
    }

    static String standardContextForm(CharSequence charSequence) {
        if (SINGLE_DIGIT.matcher(charSequence).matches()) {
            return "single_digit";
        }
        if (DECIMAL_NUMBER.matcher(charSequence).matches()) {
            return "decimal_number";
        }
        if (BIG_NUMBER.matcher(charSequence).matches()) {
            return "big_number";
        }
        return charSequence.toString().toLowerCase();
    }

    static String standardContextForm(Token t) {
        return Acronyms.standardContextForm(t.getText());
    }

    static String standardAcronymForm(CharSequence charSequence) {
        return charSequence.toString().replace('&', '/').replace('+', '/');
    }

    static String standardAcronymForm(Token t) {
        return Acronyms.standardAcronymForm(t.getText());
    }
}

