/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.serialization.YamlSerialization;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

@ProvidedBy(value=Loader.class)
class AlignmentModel
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlignmentModel.class);
    private List<String> longforms;
    private boolean caseSensitive;
    private transient Map<String, Double> cachedScores = new HashMap<String, Double>();

    private AlignmentModel(List<String> longforms, boolean caseSensitive) {
        this.longforms = longforms;
        this.caseSensitive = caseSensitive;
    }

    public static void main(String[] args) throws IOException {
        Path longformsPath = Paths.get(args[0], new String[0]);
        Path outPath = Paths.get(args[1], new String[0]);
        boolean caseSensitive = args.length > 2;
        AlignmentModel.create(longformsPath, caseSensitive).serialize(outPath);
    }

    public static AlignmentModel create(Path longformsPath, boolean caseSensitive) throws IOException {
        Set longforms = Files.lines(longformsPath).collect(Collectors.toSet());
        return new AlignmentModel(new ArrayList<String>(longforms), caseSensitive);
    }

    public static AlignmentModel create(Path longformsPath) throws IOException {
        return AlignmentModel.create(longformsPath, false);
    }

    public List<String> getLongforms() {
        return this.longforms;
    }

    public void setLongforms(List<String> longforms) {
        this.longforms = longforms;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void serialize(Path outPath) throws IOException {
        Yaml yaml = YamlSerialization.createYaml();
        FileWriter writer = new FileWriter(outPath.toFile());
        yaml.dump((Object)this, (Writer)writer);
        writer.close();
    }

    private double align(String abbr, String longform) {
        if (!this.caseSensitive) {
            abbr = abbr.toLowerCase();
            longform = longform.toLowerCase();
        }
        double match = 1.0;
        double wordInitialMatch = 3.0;
        double initialMatch = 5.0;
        double delAbbr = -3.0;
        double delLong = 0.0;
        double delLongWordInitial = -2.0;
        ArrayList breakingChars = new ArrayList();
        Collections.addAll(breakingChars, Character.valueOf(' '), Character.valueOf('-'), Character.valueOf('/'));
        int m = abbr.length();
        int n = longform.length();
        double[][] matrix = new double[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            for (int j = 0; j <= n; ++j) {
                double downScore;
                double max = -1.7976931348623157E308;
                if (i == 0 && j == 0) {
                    max = 0.0;
                }
                if (i > 0 && j > 0 && abbr.charAt(i - 1) == longform.charAt(j - 1)) {
                    double diagScore = matrix[i - 1][j - 1];
                    diagScore = j == 1 && i == 1 ? (diagScore += initialMatch) : (j < 2 || breakingChars.contains(Character.valueOf(longform.charAt(j - 2))) ? (diagScore += wordInitialMatch) : (diagScore += match));
                    if (diagScore > max) {
                        max = diagScore;
                    }
                }
                if (i > 0 && (downScore = matrix[i - 1][j] + delAbbr) > max) {
                    max = downScore;
                }
                if (j > 0) {
                    double rightScore = matrix[i][j - 1];
                    rightScore = j < 2 || breakingChars.contains(Character.valueOf(longform.charAt(j - 2))) ? (rightScore += delLongWordInitial) : (rightScore += delLong);
                    if (rightScore > max) {
                        max = rightScore;
                    }
                }
                matrix[i][j] = max;
            }
        }
        return matrix[m][n];
    }

    String findBestLongform(String abbrev) {
        String best = abbrev;
        double maxScore = -1.7976931348623157E308;
        for (String longform : this.longforms) {
            double thisScore = this.align(abbrev, longform);
            if (!(thisScore > maxScore)) continue;
            maxScore = thisScore;
            best = longform;
        }
        return best;
    }

    List<String> findBestLongforms(String abbrev) {
        ArrayList<String> best = new ArrayList<String>();
        double maxScore = -1.7976931348623157E308;
        for (String longform : this.longforms) {
            double thisScore = this.align(abbrev, longform);
            if (thisScore > maxScore) {
                maxScore = thisScore;
                best = new ArrayList();
            }
            if (thisScore != maxScore) continue;
            best.add(longform);
        }
        return best;
    }

    Map<String, Double> rankLongforms(String abbrev) {
        LinkedHashMap<String, Double> longformScores = new LinkedHashMap<String, Double>();
        for (String longform : this.longforms) {
            longformScores.put(longform, this.align(abbrev, longform));
        }
        TreeMap<String, Double> sortedScores = new TreeMap<String, Double>((o1, o2) -> {
            int comparison = ((Double)longformScores.get(o2)).compareTo((Double)longformScores.get(o1));
            if (comparison == 0) {
                comparison = o1.compareTo((String)o2);
            }
            return comparison;
        });
        sortedScores.putAll(longformScores);
        return sortedScores;
    }

    @Singleton
    static class Loader
    extends DataLoader<AlignmentModel> {
        private final Path modelPath;

        @Inject
        public Loader(@Setting(value="acronym.alignmentModel.asDataPath") Path modelPath) {
            this.modelPath = modelPath;
        }

        @Override
        protected AlignmentModel loadModel() throws BiomedicusException {
            LOGGER.info("Loading acronym alignment model: {}", (Object)this.modelPath);
            Yaml yaml = YamlSerialization.createYaml();
            try {
                return (AlignmentModel)yaml.load((Reader)Files.newBufferedReader(this.modelPath));
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
        }
    }
}

