/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import edu.umn.biomedicus.acronym.AcronymModel;
import edu.umn.biomedicus.acronym.OrthographicAcronymModel;
import edu.umn.biomedicus.acronyms.Acronym;
import edu.umn.biomedicus.acronyms.OtherAcronymSense;
import edu.umn.biomedicus.acronyms.ScoredSense;
import edu.umn.biomedicus.annotations.ComponentSetting;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.tagging.PosTag;
import edu.umn.biomedicus.tokenization.ParseToken;
import edu.umn.biomedicus.tokenization.TermToken;
import edu.umn.biomedicus.tokenization.Token;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.DocumentTask;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Labeler;
import edu.umn.nlpengine.TextRange;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DetectAcronyms
implements DocumentTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetectAcronyms.class);
    private static final Set<PartOfSpeech> EXCLUDE_POS = EnumSet.of(PartOfSpeech.PRP, new PartOfSpeech[]{PartOfSpeech.DT, PartOfSpeech.CC, PartOfSpeech.IN, PartOfSpeech.UH, PartOfSpeech.TO, PartOfSpeech.RP, PartOfSpeech.PDT, PartOfSpeech.WP, PartOfSpeech.WP$, PartOfSpeech.WDT, PartOfSpeech.POS, PartOfSpeech.MD});
    private final AcronymModel model;
    @Nullable
    private final OrthographicAcronymModel orthographicModel;
    private final boolean checkParseTokens;
    private final Boolean labelOtherSenses;
    private Labeler<Acronym> acronymLabeler;
    private List<TermToken> termTokens;
    private Labeler<OtherAcronymSense> otherSenseLabeler;

    @Inject
    public DetectAcronyms(AcronymModel model, @ComponentSetting(value="acronym.checkParseTokens") Boolean checkParseTokens, @ComponentSetting(value="acronym.labelOtherSenses") Boolean labelOtherSenses, @Nullable OrthographicAcronymModel orthographicModel) {
        this.orthographicModel = orthographicModel;
        this.model = model;
        this.checkParseTokens = checkParseTokens;
        this.labelOtherSenses = labelOtherSenses;
    }

    public void run(@Nonnull Document document) {
        LOGGER.debug("Detecting acronyms in a document.");
        LabelIndex termTokenLabels = document.labelIndex(TermToken.class);
        LabelIndex partOfSpeechLabels = document.labelIndex(PosTag.class);
        LabelIndex parseTokenLabels = document.labelIndex(ParseToken.class);
        this.acronymLabeler = document.labeler(Acronym.class);
        this.otherSenseLabeler = document.labeler(OtherAcronymSense.class);
        List termTokenLabelList = termTokenLabels.asList();
        this.termTokens = termTokenLabels.asList();
        int size = termTokenLabels.size();
        for (int i = 0; i < size; ++i) {
            ParseToken parseToken;
            TermToken termToken = (TermToken)termTokenLabelList.get(i);
            List partOfSpeechLabelsForToken = partOfSpeechLabels.inside((TextRange)termToken).asList();
            if (partOfSpeechLabelsForToken.stream().map(PosTag::getPartOfSpeech).allMatch(EXCLUDE_POS::contains) || this.checkAndLabel(i, termToken) || !this.checkParseTokens) continue;
            Iterator iterator2 = parseTokenLabels.inside((TextRange)termToken).iterator();
            while (iterator2.hasNext() && (EXCLUDE_POS.contains((Object)((PosTag)((Object)partOfSpeechLabels.atLocation((TextRange)(parseToken = (ParseToken)iterator2.next())).iterator().next())).getPartOfSpeech()) || !this.checkAndLabel(i, parseToken))) {
            }
        }
    }

    private <T extends Token & TextRange> boolean checkAndLabel(int i, T token) {
        List<ScoredSense> senses;
        boolean found = false;
        if ((this.model.hasAcronym(token) || this.orthographicModel != null && this.orthographicModel.seemsLikeAbbreviation(token)) && (senses = this.model.findBestSense(this.termTokens, i)).size() > 0) {
            ScoredSense first = senses.get(0);
            this.acronymLabeler.add((Label)new Acronym(token, first.getSense(), token.getHasSpaceAfter(), first.getScore()));
            if (this.labelOtherSenses.booleanValue()) {
                for (int j = 1; j < senses.size(); ++j) {
                    ScoredSense scoredSense = senses.get(j);
                    this.otherSenseLabeler.add((Label)new OtherAcronymSense(token, scoredSense.getSense(), token.getHasSpaceAfter(), scoredSense.getScore()));
                }
            }
            found = true;
        }
        return found;
    }
}

