/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import com.google.inject.Inject;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.collect.HashIndexMap;
import edu.umn.biomedicus.common.collect.IndexMap;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import edu.umn.biomedicus.tokenization.Token;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

@ProvidedBy(value=Loader.class)
public class OrthographicAcronymModel
implements Serializable {
    static final IndexMap<Character> CASE_SENS_SYMBOLS;
    static final Set<Character> CASE_SENS_CHARS;
    static final IndexMap<Character> CASE_INSENS_SYMBOLS;
    static final Set<Character> CASE_INSENS_CHARS;
    private final double[][][] abbrevProbs;
    private final double[][][] longformProbs;
    private final boolean caseSensitive;
    private final Set<String> longformsLower;
    private final transient IndexMap<Character> symbols;
    private final transient Set<Character> chars;

    private OrthographicAcronymModel(double[][][] abbrevProbs, double[][][] longformProbs, boolean caseSensitive, Set<String> longformsLower) {
        this.abbrevProbs = abbrevProbs;
        this.longformProbs = longformProbs;
        this.caseSensitive = caseSensitive;
        this.longformsLower = longformsLower;
        this.symbols = caseSensitive ? CASE_SENS_SYMBOLS : CASE_INSENS_SYMBOLS;
        this.chars = caseSensitive ? CASE_SENS_CHARS : CASE_INSENS_CHARS;
    }

    boolean seemsLikeAbbreviation(Token token) {
        String wordRaw = token.getText();
        String wordLower = wordRaw.toLowerCase();
        if (this.longformsLower != null && this.longformsLower.contains(wordLower)) {
            return false;
        }
        if (wordRaw.length() < 2) {
            return false;
        }
        if (wordLower.matches("[^a-z]*")) {
            return false;
        }
        if (wordLower.matches("[^bcdfghjklmnpqrstvwxz]*")) {
            return true;
        }
        if (wordLower.matches("[^aeiouy]*")) {
            return true;
        }
        return this.seemsLikeAbbrevByTrigram(wordRaw);
    }

    private boolean seemsLikeAbbrevByTrigram(String form) {
        return this.abbrevProbs != null && this.longformProbs != null && this.getWordLikelihood(form, this.abbrevProbs) > this.getWordLikelihood(form, this.longformProbs);
    }

    private double getWordLikelihood(String word, double[][][] probs) {
        char minus2 = '^';
        char minus1 = '^';
        char thisChar = '^';
        double logProb = 0.0;
        for (int i = 0; i < word.length(); ++i) {
            thisChar = this.fixChar(word.charAt(i));
            logProb += probs[this.symbols.indexOf(Character.valueOf(minus2))][this.symbols.indexOf(Character.valueOf(minus1))][this.symbols.indexOf(Character.valueOf(thisChar))];
            minus2 = minus1;
            minus1 = thisChar;
        }
        logProb += probs[this.symbols.indexOf(Character.valueOf(minus1))][this.symbols.indexOf(Character.valueOf(thisChar))][this.symbols.indexOf(Character.valueOf('$'))];
        return logProb += probs[this.symbols.indexOf(Character.valueOf(thisChar))][this.symbols.indexOf(Character.valueOf('$'))][this.symbols.indexOf(Character.valueOf('$'))];
    }

    private char fixChar(char c) {
        if (!this.caseSensitive) {
            c = Character.toLowerCase(c);
        }
        if (Character.isDigit(c)) {
            c = (char)48;
        } else if (!this.chars.contains(Character.valueOf(c))) {
            c = (char)63;
        }
        return c;
    }

    static {
        Set symbols = "abcdefghijklmnopqrstuvwxyz.-ABCDEFGHIJKLMNOPQRSTUVWXYZ0?^$".chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toSet());
        CASE_SENS_SYMBOLS = new HashIndexMap<Character>(symbols);
        CASE_SENS_CHARS = "abcdefghijklmnopqrstuvwxyz.-ABCDEFGHIJKLMNOPQRSTUVWXYZ".chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toSet());
        Set caseInsensSymbols = "abcdefghijklmnopqrstuvwxyz.-0?^$".chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toSet());
        CASE_INSENS_SYMBOLS = new HashIndexMap<Character>(caseInsensSymbols);
        CASE_INSENS_CHARS = "abcdefghijklmnopqrstuvwxyz.-".chars().mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toSet());
    }

    @Singleton
    static class Loader
    extends DataLoader<OrthographicAcronymModel> {
        private final Path orthographicModel;
        private IndexMap<Character> symbols;

        @Inject
        Loader(@Setting(value="acronym.orthographicModel.asDataPath") Path orthographicModel) {
            this.orthographicModel = orthographicModel;
        }

        @Override
        protected OrthographicAcronymModel loadModel() throws BiomedicusException {
            Yaml yaml = new Yaml();
            try {
                Map serObj = (Map)yaml.load((Reader)Files.newBufferedReader(this.orthographicModel));
                boolean caseSensitive = (Boolean)serObj.get("caseSensitive");
                this.symbols = caseSensitive ? CASE_SENS_SYMBOLS : CASE_INSENS_SYMBOLS;
                Map abbrevProbsMap = (Map)serObj.get("abbrevProbs");
                double[][][] abbrevProbs = this.expandProbs(abbrevProbsMap);
                Map longformProbsMap = (Map)serObj.get("longformProbs");
                double[][][] longformProbs = this.expandProbs(longformProbsMap);
                HashSet longformsLower = new HashSet();
                List longformsLowerList = (List)serObj.get("longformsLower");
                longformsLower.addAll(longformsLowerList);
                return new OrthographicAcronymModel(abbrevProbs, longformProbs, caseSensitive, longformsLower);
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
        }

        private double[][][] expandProbs(Map<String, Double> collapsedProbs) {
            double[][][] probs = new double[this.symbols.size()][this.symbols.size()][this.symbols.size()];
            for (Map.Entry<String, Double> entry : collapsedProbs.entrySet()) {
                String key = entry.getKey();
                probs[this.symbols.indexOf((Character)Character.valueOf((char)key.charAt((int)0))).intValue()][this.symbols.indexOf((Character)Character.valueOf((char)key.charAt((int)1))).intValue()][this.symbols.indexOf((Character)Character.valueOf((char)key.charAt((int)2))).intValue()] = entry.getValue();
            }
            return probs;
        }
    }
}

