/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import edu.umn.biomedicus.acronym.HashSenseVectors;
import edu.umn.biomedicus.acronym.SenseVectors;
import edu.umn.biomedicus.acronym.SparseVector;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDBSenseVectors
implements SenseVectors {
    private final RocksDB rocksDB;
    private transient int _size;

    public RocksDBSenseVectors(Path path, boolean forWriting) {
        block17: {
            this._size = -1;
            RocksDB.loadLibrary();
            if (forWriting) {
                try (Options options = new Options().setCreateIfMissing(true).prepareForBulkLoad();){
                    this.rocksDB = RocksDB.open((Options)options, (String)path.toString());
                    break block17;
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.rocksDB = RocksDB.openReadOnly((String)path.toString());
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean containsSense(@Nullable String sense) {
        if (sense == null) {
            return false;
        }
        byte[] bytes = sense.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] value = this.rocksDB.get(bytes);
            return value != null;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public SparseVector get(@Nullable String sense) {
        if (sense == null) {
            return null;
        }
        byte[] bytes = sense.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] value = this.rocksDB.get(bytes);
            return new SparseVector(value);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> senses() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                final RocksIterator rocksIterator = RocksDBSenseVectors.this.rocksDB.newIterator();
                rocksIterator.seekToFirst();
                return new Iterator<String>(){
                    boolean closed = false;

                    @Override
                    public boolean hasNext() {
                        return this.closed || rocksIterator.isValid();
                    }

                    @Override
                    public String next() {
                        if (!rocksIterator.isValid()) {
                            throw new NoSuchElementException();
                        }
                        String sense = new String(rocksIterator.key(), StandardCharsets.UTF_8);
                        rocksIterator.next();
                        if (!rocksIterator.isValid()) {
                            this.closed = true;
                            rocksIterator.close();
                        }
                        return sense;
                    }

                    protected void finalize() {
                        if (!this.closed) {
                            rocksIterator.close();
                        }
                    }
                };
            }

            @Override
            public boolean contains(Object o) {
                return o != null && o instanceof String && RocksDBSenseVectors.this.containsSense((String)o);
            }

            @Override
            public int size() {
                return RocksDBSenseVectors.this.size();
            }
        };
    }

    @Override
    public Collection<SparseVector> vectors() {
        return new AbstractCollection<SparseVector>(){

            @Override
            public Iterator<SparseVector> iterator() {
                final RocksIterator rocksIterator = RocksDBSenseVectors.this.rocksDB.newIterator();
                rocksIterator.seekToFirst();
                return new Iterator<SparseVector>(){
                    boolean closed = false;

                    @Override
                    public boolean hasNext() {
                        return this.closed || rocksIterator.isValid();
                    }

                    @Override
                    public SparseVector next() {
                        if (!rocksIterator.isValid()) {
                            throw new NoSuchElementException();
                        }
                        SparseVector sparseVector = new SparseVector(rocksIterator.value());
                        rocksIterator.next();
                        if (!rocksIterator.isValid()) {
                            this.closed = true;
                            rocksIterator.close();
                        }
                        return sparseVector;
                    }

                    protected void finalize() {
                        if (!this.closed) {
                            rocksIterator.close();
                        }
                    }
                };
            }

            @Override
            public int size() {
                return RocksDBSenseVectors.this.size();
            }
        };
    }

    @Override
    public void removeWord(int index) {
        try (WriteBatch writeBatch = new WriteBatch();){
            try (RocksIterator rocksIterator = this.rocksDB.newIterator();){
                rocksIterator.seekToFirst();
                while (rocksIterator.isValid()) {
                    SparseVector sparseVector = new SparseVector(rocksIterator.value());
                    sparseVector.remove(index);
                    writeBatch.put(rocksIterator.key(), sparseVector.toBytes());
                }
            }
            this.rocksDB.write(new WriteOptions(), writeBatch);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeWords(Collection<Integer> indexes) {
        try (WriteBatch writeBatch = new WriteBatch();){
            try (RocksIterator rocksIterator = this.rocksDB.newIterator();){
                rocksIterator.seekToFirst();
                while (rocksIterator.isValid()) {
                    SparseVector sparseVector = new SparseVector(rocksIterator.value());
                    sparseVector.removeAll(indexes);
                    writeBatch.put(rocksIterator.key(), sparseVector.toBytes());
                }
            }
            this.rocksDB.write(new WriteOptions(), writeBatch);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        int size = this._size;
        if (size != -1) {
            return size;
        }
        size = 0;
        try (RocksIterator rocksIterator = this.rocksDB.newIterator();){
            rocksIterator.seekToFirst();
            while (rocksIterator.isValid()) {
                ++size;
                rocksIterator.next();
            }
        }
        this._size = size;
        return this._size;
    }

    @Override
    public void close() {
        this.rocksDB.close();
    }

    public SenseVectors inMemory(@Nullable Boolean sensesInMemory) {
        if (sensesInMemory != null && sensesInMemory.booleanValue()) {
            HashMap<String, SparseVector> map = new HashMap<String, SparseVector>(this.size());
            try (RocksIterator rocksIterator = this.rocksDB.newIterator();){
                rocksIterator.seekToFirst();
                while (rocksIterator.isValid()) {
                    map.put(new String(rocksIterator.key(), StandardCharsets.UTF_8), new SparseVector(rocksIterator.value()));
                    rocksIterator.next();
                }
            }
            this.rocksDB.close();
            return new HashSenseVectors(map);
        }
        return this;
    }

    void putAll(Map<String, SparseVector> map) {
        map.forEach((key, value) -> {
            try {
                this.rocksDB.put(key.getBytes(StandardCharsets.UTF_8), value.toBytes());
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

