/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.acronym;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SparseVector {
    private static final int ENTRY_BYTES = 12;
    private static final int DEFAULT_SIZE = 10;
    private int[] keys;
    private double[] values;
    private int size;

    public SparseVector() {
        this.keys = new int[10];
        this.values = new double[10];
        this.size = 0;
    }

    public SparseVector(SparseVector other) {
        this.size = other.size;
        this.keys = new int[this.size];
        System.arraycopy(other.keys, 0, this.keys, 0, this.size);
        this.values = new double[this.size];
        System.arraycopy(other.values, 0, this.values, 0, this.size);
    }

    public SparseVector(Map<Integer, Double> vector) {
        this.setVector(vector);
    }

    public SparseVector(byte[] bytes) {
        this.size = bytes.length / 12;
        this.keys = new int[this.size];
        this.values = new double[this.size];
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = wrap.getInt();
            this.values[i] = wrap.getDouble();
        }
    }

    public void setVector(Map<Integer, Double> vector) {
        this.size = vector.size();
        this.keys = new int[this.size];
        this.values = new double[this.size];
        List list = vector.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry entry = (Map.Entry)list.get(i);
            this.keys[i] = (Integer)entry.getKey();
            this.values[i] = (Double)entry.getValue();
        }
    }

    public double magnitude() {
        double sqsum = 0.0;
        for (double x : this.values) {
            sqsum += x * x;
        }
        return Math.sqrt(sqsum);
    }

    public void normVector() {
        double mag = this.magnitude();
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = this.values[i] / mag;
        }
    }

    public void add(SparseVector other) {
        int newSize = 0;
        int[] newKeys = new int[this.size + other.size];
        double[] newValues = new double[this.size + other.size];
        int ptr = 0;
        int otherPtr = 0;
        while (ptr < this.size && otherPtr < other.size) {
            int key = this.keys[ptr];
            int otherKey = other.keys[otherPtr];
            if (key == otherKey) {
                newKeys[newSize] = key;
                newValues[newSize++] = this.values[ptr++] + other.values[otherPtr++];
                continue;
            }
            if (key < otherKey) {
                newKeys[newSize] = key;
                newValues[newSize++] = this.values[ptr++];
                continue;
            }
            newKeys[newSize] = otherKey;
            newValues[newSize++] = other.values[otherPtr++];
        }
        while (ptr < this.size) {
            newKeys[newSize] = this.keys[ptr];
            newValues[newSize++] = this.values[ptr++];
        }
        while (otherPtr < this.size) {
            newKeys[newSize] = other.keys[otherPtr];
            newValues[newSize++] = other.values[otherPtr++];
        }
        this.keys = newKeys;
        this.values = newValues;
        this.size = newSize;
    }

    public void multiply(SparseVector other) {
        int newSize = 0;
        int cap = Math.min(this.size, other.size);
        int[] newKeys = new int[cap];
        double[] newValues = new double[cap];
        int ptr = 0;
        int otherPtr = 0;
        while (ptr < this.size && otherPtr < other.size) {
            int key = this.keys[ptr];
            int otherKey = other.keys[otherPtr];
            if (key == otherKey) {
                newKeys[newSize] = key;
                newValues[newSize++] = this.values[ptr++] * other.values[otherPtr++];
                continue;
            }
            if (key < otherKey) {
                ++ptr;
                continue;
            }
            ++otherPtr;
        }
        this.size = newSize;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void applyOperation(DoubleUnaryOperator operation) {
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = operation.applyAsDouble(this.values[i]);
        }
    }

    public double dot(SparseVector other) {
        double sum = 0.0;
        int ptr = 0;
        int otherPtr = 0;
        while (ptr < this.size && otherPtr < other.size) {
            int key = this.keys[ptr];
            int otherKey = other.keys[otherPtr];
            if (key == otherKey) {
                sum += this.values[ptr++] * other.values[otherPtr++];
                continue;
            }
            if (key < otherKey) {
                ++ptr;
                continue;
            }
            ++otherPtr;
        }
        return sum;
    }

    public double get(int i) {
        int index = Arrays.binarySearch(this.keys, i);
        if (index >= 0 && index < this.size) {
            return this.keys[index];
        }
        return 0.0;
    }

    public double set(int ind, double val) {
        int insert = Arrays.binarySearch(this.keys, ind);
        if (insert >= 0 && insert < this.size) {
            double existing = this.values[insert];
            if (val == 0.0) {
                this.removeInternal(insert);
            } else {
                this.values[insert] = val;
            }
            return existing;
        }
        if (val == 0.0) {
            return 0.0;
        }
        if (this.size + 1 > this.keys.length) {
            int newCapacity = this.keys.length + (this.keys.length >> 1);
            this.keys = Arrays.copyOf(this.keys, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }
        System.arraycopy(this.keys, insert, this.keys, insert + 1, this.size - insert);
        System.arraycopy(this.values, insert, this.values, insert + 1, this.size - insert);
        this.keys[insert] = ind;
        this.values[insert] = val;
        ++this.size;
        return 0.0;
    }

    public void remove(@Nullable Integer index) {
        if (index != null) {
            int i = Arrays.binarySearch(this.keys, index);
            this.removeInternal(i);
        }
    }

    private void removeInternal(int i) {
        if (i == this.size - 1) {
            --this.size;
            return;
        }
        if (i >= 0 && i < this.size) {
            System.arraycopy(this.keys, i + 1, this.keys, i, this.size - i - 1);
        }
    }

    public void removeAll(@Nullable Collection<Integer> indexes) {
        if (indexes == null) {
            return;
        }
        int newSize = 0;
        int[] newKeys = new int[this.size];
        double[] newValues = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            if (indexes.contains(i)) continue;
            newKeys[newSize] = this.keys[i];
            newValues[newSize++] = this.values[i];
        }
        this.size = newSize;
        this.keys = newKeys;
        this.values = newValues;
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(this.size * 12);
        for (int i = 0; i < this.size; ++i) {
            buffer.putInt(this.keys[i]).putDouble(this.values[i]);
        }
        return buffer.array();
    }
}

