/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.collect;

import edu.umn.biomedicus.common.collect.IndexMap;
import java.util.Collection;
import java.util.HashMap;

public class HashIndexMap<T>
implements IndexMap<T> {
    private final HashMap<T, Integer> indexMap = new HashMap();
    private final HashMap<Integer, T> instanceMap = new HashMap();

    public HashIndexMap() {
    }

    public HashIndexMap(Collection<? extends T> collection) {
        collection.forEach(this::addItem);
    }

    @Override
    public int size() {
        return this.indexMap.size();
    }

    @Override
    public boolean contains(T item) {
        return this.indexMap.containsKey(item);
    }

    @Override
    public void addItem(T item) {
        if (!this.indexMap.containsKey(item)) {
            int index = this.indexMap.size();
            this.indexMap.put(item, index);
            this.instanceMap.put(index, item);
        }
    }

    @Override
    public T forIndex(int index) {
        return this.instanceMap.get(index);
    }

    @Override
    public Integer indexOf(T item) {
        return this.indexMap.get(item);
    }
}

