/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.collect;

import edu.umn.biomedicus.common.collect.Metric;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class MetricTree<T> {
    private final Node<T> rootNode;
    private final Metric<T> metric;

    private MetricTree(Node<T> rootNode, Metric<T> metric) {
        this.rootNode = rootNode;
        this.metric = metric;
    }

    private MetricTree(MutableNode<T> rootNode, Metric<T> metric) {
        this.rootNode = ((MutableNode)rootNode).build(this);
        this.metric = metric;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Stream<T> search(T word, int maxDistance) {
        return ((Node)this.rootNode).search(this.metric, word, maxDistance);
    }

    public static class Builder<T> {
        @Nullable
        private MutableNode<T> rootNode = null;
        @Nullable
        private Metric<T> metric;

        private Builder() {
        }

        public Builder<T> withMetric(Metric<T> metric) {
            this.metric = metric;
            return this;
        }

        public Builder<T> add(T word) {
            int distance;
            if (this.metric == null) {
                throw new IllegalStateException("Edit distance method needs to be set before adding words");
            }
            if (this.rootNode == null) {
                this.rootNode = new MutableNode(word);
            }
            MutableNode currentNode = this.rootNode;
            while ((distance = this.metric.compute(currentNode.word, word)) != 0) {
                if (!currentNode.children.containsKey(distance)) {
                    currentNode.children.put(distance, new MutableNode(word));
                    break;
                }
                currentNode = (MutableNode)currentNode.children.get(distance);
            }
            return this;
        }

        public MetricTree<T> build() {
            if (this.rootNode == null) {
                throw new IllegalStateException("Empty BK Tree");
            }
            if (this.metric == null) {
                throw new IllegalStateException("Edit distance method needs to be set before adding words");
            }
            return new MetricTree(this.rootNode, this.metric);
        }
    }

    private static class MutableNode<T> {
        private final T word;
        private final Map<Integer, MutableNode<T>> children = new HashMap<Integer, MutableNode<T>>();

        private MutableNode(T word) {
            this.word = word;
        }

        private Node<T> build(MetricTree<T> metricTree) {
            int childrenSize = this.children.size();
            if (childrenSize == 0) {
                return new Node(this.word, null, null);
            }
            List<Map.Entry<Integer, MutableNode<T>>> sorted = this.sortChildrenByDistance();
            int[] distances = new int[childrenSize];
            Node[] nodes = (Node[])Array.newInstance(new Node().getClass(), childrenSize);
            for (int i = 0; i < childrenSize; ++i) {
                Map.Entry<Integer, MutableNode<T>> entry = sorted.get(i);
                distances[i] = entry.getKey();
                nodes[i] = super.build(metricTree);
            }
            return new Node(this.word, distances, nodes);
        }

        private List<Map.Entry<Integer, MutableNode<T>>> sortChildrenByDistance() {
            return this.children.entrySet().stream().sorted((first, second) -> ((Integer)first.getKey()).compareTo((Integer)second.getKey())).collect(Collectors.toList());
        }
    }

    private static class Node<T> {
        private final T word;
        @Nullable
        private final int[] childDistances;
        @Nullable
        private final Node<T>[] children;

        private Node() {
            this.word = null;
            this.childDistances = null;
            this.children = null;
        }

        private Node(T word, @Nullable int[] childDistances, @Nullable Node<T>[] children) {
            this.word = word;
            this.childDistances = childDistances;
            this.children = children;
        }

        private Stream<T> search(Metric<T> metric, T query, int maxDistance) {
            int distance = metric.compute(query, this.word);
            int min = distance - maxDistance;
            int max = distance + maxDistance;
            Stream<Object> returnStream = this.childrenBetween(min, max).flatMap(child -> child.search(metric, query, maxDistance));
            if (distance <= maxDistance) {
                returnStream = Stream.concat(Stream.of(this.word), returnStream);
            }
            return returnStream;
        }

        private Stream<Node<T>> childrenBetween(int min, int max) {
            if (this.childDistances == null || this.children == null) {
                return Stream.empty();
            }
            int minIndex = Math.abs(Arrays.binarySearch(this.childDistances, min));
            int maxIndex = Math.abs(Arrays.binarySearch(this.childDistances, minIndex, this.childDistances.length, max));
            return Arrays.stream(this.children, minIndex, maxIndex);
        }
    }
}

