/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.collect;

import edu.umn.biomedicus.common.collect.Costs;
import edu.umn.biomedicus.common.collect.Metric;

public class StandardEditDistance<T extends CharSequence>
implements Metric<T> {
    private final Costs costs;

    public StandardEditDistance(Costs costs) {
        this.costs = costs;
    }

    public static <T extends CharSequence> StandardEditDistance<T> levenstein() {
        return new StandardEditDistance<T>(Costs.LEVENSHTEIN);
    }

    @Override
    public int compute(T first, T second) {
        int firstLength = first.length();
        int secondLength = second.length();
        if (firstLength == 0) {
            return secondLength * this.costs.getInsert();
        }
        if (secondLength == 0) {
            return firstLength * this.costs.getInsert();
        }
        int[] lastRow = new int[secondLength + 1];
        int[] thisRow = new int[secondLength + 1];
        for (int column = 0; column <= secondLength; ++column) {
            lastRow[column] = column * this.costs.getDelete();
        }
        for (int row = 1; row <= firstLength; ++row) {
            int column = 0;
            thisRow[column] = row * this.costs.getDelete();
            for (column = 1; column <= secondLength; ++column) {
                boolean isMatch = first.charAt(row - 1) == second.charAt(column - 1);
                int matchOrReplace = (isMatch ? this.costs.getMatch() : this.costs.getReplace()) + lastRow[column - 1];
                int insert = this.costs.getInsert() + thisRow[column - 1];
                int delete = this.costs.getDelete() + lastRow[column];
                thisRow[column] = Math.min(Math.min(matchOrReplace, insert), delete);
            }
            int[] swap = lastRow;
            lastRow = thisRow;
            thisRow = swap;
        }
        return lastRow[secondLength];
    }
}

