/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.dictionary;

import edu.umn.biomedicus.common.dictionary.AbstractIdentifiers;
import edu.umn.biomedicus.common.dictionary.MappingIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public final class HashIdentifiers
extends AbstractIdentifiers {
    private final Map<String, Integer> map;

    public HashIdentifiers() {
        this.map = new HashMap<String, Integer>();
    }

    public HashIdentifiers(int size) {
        this.map = new HashMap<String, Integer>(size);
    }

    void addMapping(String string, int identifier) {
        this.map.put(string, identifier);
    }

    @Override
    protected int getIdentifier(@Nullable CharSequence term) {
        if (term == null) {
            return -1;
        }
        Integer identifier = this.map.get(term.toString());
        return identifier == null ? -1 : identifier;
    }

    @Override
    public boolean contains(@Nullable String string) {
        return string != null && this.map.containsKey(string);
    }

    @Override
    public MappingIterator mappingIterator() {
        final Iterator<Map.Entry<String, Integer>> iterator2 = this.map.entrySet().iterator();
        return new MappingIterator(){
            @Nullable
            private Map.Entry<String, Integer> value = null;
            {
                if (iterator2.hasNext()) {
                    this.value = (Map.Entry)iterator2.next();
                }
            }

            @Override
            public boolean isValid() {
                return this.value != null;
            }

            @Override
            public int identifier() {
                return this.value.getValue();
            }

            @Override
            public String string() {
                return this.value.getKey();
            }

            @Override
            public void next() {
                this.value = iterator2.hasNext() ? (Map.Entry)iterator2.next() : null;
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void close() {
    }
}

