/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.dictionary;

import edu.umn.biomedicus.common.dictionary.AbstractIdentifiers;
import edu.umn.biomedicus.common.dictionary.MappingIterator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public final class RocksDbIdentifiers
extends AbstractIdentifiers
implements Closeable {
    private final RocksDB indices;
    private transient int _size = -1;

    public RocksDbIdentifiers(Path identifiersPath) {
        RocksDB.loadLibrary();
        try (Options options = new Options().setInfoLogLevel(InfoLogLevel.ERROR_LEVEL);){
            this.indices = RocksDB.openReadOnly((Options)options, (String)identifiersPath.toString());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int getIdentifier(@Nullable CharSequence term) {
        if (term == null) {
            return -1;
        }
        byte[] bytes = term.toString().getBytes(StandardCharsets.UTF_8);
        try {
            byte[] idBytes = this.indices.get(bytes);
            if (idBytes == null) {
                return -1;
            }
            return ByteBuffer.wrap(idBytes).getInt();
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.indices.close();
    }

    @Override
    public boolean contains(@Nullable String string) {
        if (string == null) {
            return false;
        }
        try {
            return this.indices.get(string.getBytes(StandardCharsets.UTF_8)) != null;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MappingIterator mappingIterator() {
        final RocksIterator rocksIterator = this.indices.newIterator();
        return new MappingIterator(){

            @Override
            public void close() {
                rocksIterator.close();
            }

            @Override
            public boolean isValid() {
                return rocksIterator.isValid();
            }

            @Override
            public int identifier() {
                byte[] value = rocksIterator.value();
                return ByteBuffer.wrap(value).getInt();
            }

            @Override
            public String string() {
                byte[] key = rocksIterator.key();
                return new String(key, StandardCharsets.UTF_8);
            }

            @Override
            public void next() {
                rocksIterator.next();
            }
        };
    }

    @Override
    public int size() {
        int size = this._size;
        if (size != -1) {
            return size;
        }
        size = 0;
        try (MappingIterator mappingIterator = this.mappingIterator();){
            while (mappingIterator.isValid()) {
                ++size;
                mappingIterator.next();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this._size = size;
        return this._size;
    }
}

