/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.dictionary;

import edu.umn.biomedicus.common.dictionary.AbstractStrings;
import edu.umn.biomedicus.common.dictionary.MappingIterator;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public final class RocksDbStrings
extends AbstractStrings {
    private final RocksDB terms;
    private transient int _size = -1;

    public RocksDbStrings(Path termsPath) {
        RocksDB.loadLibrary();
        try {
            this.terms = RocksDB.openReadOnly((String)termsPath.toString());
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getTerm(int termIdentifier) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(termIdentifier).array();
        try {
            byte[] termBytes = this.terms.get(bytes);
            return new String(termBytes, StandardCharsets.UTF_8);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MappingIterator mappingIterator() {
        final RocksIterator rocksIterator = this.terms.newIterator();
        rocksIterator.seekToFirst();
        return new MappingIterator(){

            @Override
            public boolean isValid() {
                return rocksIterator.isValid();
            }

            @Override
            public int identifier() {
                byte[] key = rocksIterator.key();
                return ByteBuffer.wrap(key).getInt();
            }

            @Override
            public String string() {
                byte[] value = rocksIterator.value();
                return new String(value, StandardCharsets.UTF_8);
            }

            @Override
            public void next() {
                rocksIterator.next();
            }

            @Override
            public void close() {
                rocksIterator.close();
            }
        };
    }

    @Override
    public int size() {
        int size = this._size;
        if (size != -1) {
            return size;
        }
        size = 0;
        MappingIterator mappingIterator = this.mappingIterator();
        while (mappingIterator.isValid()) {
            ++size;
            mappingIterator.next();
        }
        this._size = size;
        return this._size;
    }

    @Override
    public void close() {
        this.terms.close();
    }
}

