/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.dictionary;

import edu.umn.biomedicus.common.dictionary.ArrayStrings;
import edu.umn.biomedicus.common.dictionary.BidirectionalDictionary;
import edu.umn.biomedicus.common.dictionary.HashIdentifiers;
import edu.umn.biomedicus.common.dictionary.MappingIterator;
import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import edu.umn.biomedicus.common.dictionary.StringsBag;
import edu.umn.biomedicus.common.dictionary.StringsVector;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class StandardBidirectionalDictionary
implements BidirectionalDictionary {
    private final BidirectionalDictionary.Identifiers identifiers;
    private final BidirectionalDictionary.Strings strings;

    public StandardBidirectionalDictionary(BidirectionalDictionary.Identifiers identifiers, BidirectionalDictionary.Strings strings) {
        this.identifiers = identifiers;
        this.strings = strings;
    }

    @Override
    public BidirectionalDictionary.Strings getStrings() {
        return this.strings;
    }

    @Override
    public BidirectionalDictionary.Identifiers getIdentifiers() {
        return this.identifiers;
    }

    @Override
    @Nullable
    public String getTerm(StringIdentifier stringIdentifier) {
        return this.strings.getTerm(stringIdentifier);
    }

    @Override
    public StringIdentifier getTermIdentifier(@Nullable CharSequence term) {
        return this.identifiers.getTermIdentifier(term);
    }

    @Override
    public List<String> getTerms(StringsVector terms) {
        return this.strings.getTerms(terms);
    }

    @Override
    public Collection<String> getTerms(StringsBag stringsBag) {
        return this.strings.getTerms(stringsBag);
    }

    @Override
    public boolean contains(String string) {
        return this.identifiers.contains(string);
    }

    @Override
    public StringsVector getTermVector(Iterable<? extends CharSequence> terms) {
        return this.identifiers.getTermVector(terms);
    }

    @Override
    public StringsBag getTermsBag(Iterable<? extends CharSequence> terms) {
        return this.identifiers.getTermsBag(terms);
    }

    @Override
    public int size() {
        return this.identifiers.size();
    }

    public StandardBidirectionalDictionary inMemory(boolean inMemory) {
        if (inMemory) {
            int size = this.identifiers.size();
            HashIdentifiers hashIdentifiers = new HashIdentifiers(size);
            String[] strings = new String[size];
            try (MappingIterator mappingIterator = this.identifiers.mappingIterator();){
                while (mappingIterator.isValid()) {
                    int identifier = mappingIterator.identifier();
                    String string = mappingIterator.string();
                    hashIdentifiers.addMapping(string, identifier);
                    strings[identifier] = string;
                    mappingIterator.next();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return new StandardBidirectionalDictionary(hashIdentifiers, new ArrayStrings(strings));
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.identifiers.close();
        this.strings.close();
    }
}

