/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.dictionary;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public final class StringIdentifier
implements Comparable<StringIdentifier> {
    private final int value;

    public StringIdentifier(int value) {
        this.value = value;
    }

    public static StringIdentifier unknown() {
        return new StringIdentifier(-1);
    }

    public static StringIdentifier withValue(int value) {
        Preconditions.checkArgument((value != -1 ? 1 : 0) != 0, (Object)"-1 is reserved for unknown terms.");
        return new StringIdentifier(value);
    }

    public int value() {
        return this.value;
    }

    public boolean isUnknown() {
        return this.value == -1;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringIdentifier that = (StringIdentifier)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(StringIdentifier o) {
        return Integer.compare(this.value, o.value);
    }
}

