/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.dictionary;

import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StringsBag
extends AbstractCollection<StringIdentifier>
implements Comparable<StringsBag> {
    private final int[] terms;
    private final int[] counts;
    private transient int _total = -1;

    public StringsBag(int[] terms, int[] counts) {
        this.terms = terms;
        this.counts = counts;
    }

    public StringsBag(byte[] bytes) {
        int size = bytes.length / 4 / 2;
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        this.terms = new int[size];
        this.counts = new int[size];
        for (int i = 0; i < size; ++i) {
            this.terms[i] = wrap.getInt();
            this.counts[i] = wrap.getInt();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<StringIdentifier> toTerms() {
        ArrayList<StringIdentifier> result = new ArrayList<StringIdentifier>();
        for (int i = 0; i < this.terms.length; ++i) {
            for (int j = 0; j < this.counts[i]; ++j) {
                result.add(new StringIdentifier(this.terms[i]));
            }
        }
        return result;
    }

    public boolean contains(StringIdentifier stringIdentifier) {
        return Arrays.binarySearch(this.terms, stringIdentifier.value()) != -1;
    }

    public int countOf(StringIdentifier stringIdentifier) {
        int index = Arrays.binarySearch(this.terms, stringIdentifier.value());
        return index < 0 ? 0 : this.counts[index];
    }

    public int uniqueTerms() {
        return this.terms.length;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringsBag that = (StringsBag)o;
        return Arrays.equals(this.terms, that.terms) && Arrays.equals(this.counts, that.counts);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.terms) * 31 + Arrays.hashCode(this.counts);
    }

    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(8 * this.terms.length);
        for (int i = 0; i < this.terms.length; ++i) {
            buffer.putInt(this.terms[i]);
            buffer.putInt(this.counts[i]);
        }
        return buffer.array();
    }

    @Override
    public Iterator<StringIdentifier> iterator() {
        return new Iterator<StringIdentifier>(){
            int index = -1;
            int identifier;
            int instances = 0;
            {
                this.advance();
            }

            void advance() {
                if (this.instances > 0) {
                    --this.instances;
                } else {
                    ++this.index;
                    if (this.index < StringsBag.this.terms.length) {
                        this.identifier = StringsBag.this.terms[this.index];
                        this.instances = StringsBag.this.counts[this.index];
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.instances > 0 || this.index < StringsBag.this.terms.length;
            }

            @Override
            public StringIdentifier next() {
                if (this.instances == 0) {
                    throw new NoSuchElementException();
                }
                int tmp = this.identifier;
                this.advance();
                return new StringIdentifier(tmp);
            }
        };
    }

    @Override
    public int size() {
        int total = this._total;
        if (total != -1) {
            return total;
        }
        total = 0;
        for (int count : this.counts) {
            total += count;
        }
        this._total = total;
        return this._total;
    }

    @Override
    public int compareTo(@Nonnull StringsBag o) {
        for (int i = 0; i < Math.max(this.terms.length, o.terms.length); ++i) {
            if (this.terms.length == i) {
                return -1;
            }
            if (o.terms.length == i) {
                return 1;
            }
            int compare = Integer.compare(this.terms[i], o.terms[i]);
            if (compare != 0) {
                return compare;
            }
            compare = Integer.compare(this.counts[i], o.counts[i]);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public static class Builder {
        private final TreeMap<Integer, Integer> identifierToCount = new TreeMap();

        public Builder() {
        }

        public Builder(Map<StringIdentifier, Integer> m) {
            for (Map.Entry<StringIdentifier, Integer> entry : m.entrySet()) {
                this.identifierToCount.put(entry.getKey().value(), entry.getValue());
            }
        }

        public Builder addTerm(StringIdentifier stringIdentifier) {
            if (stringIdentifier.isUnknown()) {
                return this;
            }
            return this.addIdentifier(stringIdentifier.value());
        }

        public Builder addIdentifier(int identifier) {
            this.identifierToCount.compute(identifier, (id, count) -> {
                if (count == null) {
                    count = 0;
                }
                return count + 1;
            });
            return this;
        }

        public StringsBag build() {
            int[] terms = new int[this.identifierToCount.size()];
            int[] counts = new int[this.identifierToCount.size()];
            Iterator<Map.Entry<Integer, Integer>> it = this.identifierToCount.entrySet().iterator();
            for (int i = 0; i < this.identifierToCount.size(); ++i) {
                Map.Entry<Integer, Integer> next = it.next();
                terms[i] = next.getKey();
                counts[i] = next.getValue();
            }
            return new StringsBag(terms, counts);
        }
    }
}

