/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.dictionary;

import edu.umn.biomedicus.common.dictionary.StringIdentifier;
import edu.umn.biomedicus.common.dictionary.StringsBag;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class StringsVector
extends AbstractList<StringIdentifier> {
    private final int[] identifiers;

    StringsVector(int[] identifiers) {
        this.identifiers = identifiers;
    }

    StringsVector(byte[] bytes) {
        int size = bytes.length / 4;
        ByteBuffer wrap = ByteBuffer.wrap(bytes);
        this.identifiers = new int[size];
        for (int i = 0; i < size; ++i) {
            this.identifiers[i] = wrap.getInt();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int size() {
        return this.identifiers.length;
    }

    @Override
    public StringIdentifier get(int index) {
        if (index < 0 || index >= this.identifiers.length) {
            throw new IndexOutOfBoundsException("invalid index: " + index);
        }
        return new StringIdentifier(this.identifiers[index]);
    }

    public StringsBag toBag() {
        StringsBag.Builder builder = StringsBag.builder();
        for (int identifier : this.identifiers) {
            builder.addIdentifier(identifier);
        }
        return builder.build();
    }

    public boolean isPrefix(List<StringIdentifier> termList) {
        Iterator<StringIdentifier> it = termList.iterator();
        for (int identifier : this.identifiers) {
            if (!it.hasNext()) {
                return false;
            }
            StringIdentifier next = it.next();
            if (next.value() == identifier) continue;
            return false;
        }
        return true;
    }

    public boolean isPrefix(StringsVector terms) {
        return this.isPrefix(terms.asTermIdentifierList());
    }

    public List<StringIdentifier> asTermIdentifierList() {
        return new ListView();
    }

    byte[] getBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.identifiers.length * 4);
        for (int identifier : this.identifiers) {
            byteBuffer.putInt(identifier);
        }
        return byteBuffer.array();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringsVector that = (StringsVector)o;
        return Arrays.equals(this.identifiers, that.identifiers);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.identifiers);
    }

    @Override
    public Iterator<StringIdentifier> iterator() {
        return new Iterator<StringIdentifier>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < StringsVector.this.identifiers.length;
            }

            @Override
            public StringIdentifier next() {
                if (this.index >= StringsVector.this.identifiers.length) {
                    throw new NoSuchElementException();
                }
                return StringsVector.this.get(this.index++);
            }
        };
    }

    public static class Builder {
        private final ArrayList<Integer> identifiers = new ArrayList();

        public Builder addTerm(StringIdentifier stringIdentifier) {
            this.identifiers.add(stringIdentifier.value());
            return this;
        }

        public Builder addIdentifier(int identifier) {
            this.identifiers.add(identifier);
            return this;
        }

        public StringsVector build() {
            return new StringsVector(this.identifiers.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    private class ListView
    extends AbstractList<StringIdentifier> {
        private ListView() {
        }

        @Override
        public StringIdentifier get(int index) {
            return new StringIdentifier(StringsVector.this.identifiers[index]);
        }

        @Override
        public int size() {
            return StringsVector.this.identifiers.length;
        }
    }
}

