/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.grams;

import edu.umn.biomedicus.common.grams.Bigram;
import edu.umn.biomedicus.common.grams.Trigram;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class Ngram<T extends Comparable<T> & Serializable>
implements Bigram<T>,
Trigram<T>,
Comparable<Ngram<T>>,
Serializable {
    private static final long serialVersionUID = 3988360323326418189L;
    private T[] backingArray;
    private int length;
    private int offset;

    public Ngram(T[] backingArray, int length, int offset) {
        this.backingArray = backingArray;
        this.length = length;
        this.offset = offset;
    }

    public static <S extends Comparable<S> & Serializable> Ngram<S> create(S first, S second) {
        Comparable[] array = (Comparable[])Array.newInstance(first.getClass(), 2);
        array[0] = first;
        array[1] = second;
        return new Ngram(array, 2, 0);
    }

    public static <S extends Comparable<S> & Serializable> Ngram<S> create(S first, S second, S third) {
        Comparable[] array = (Comparable[])Array.newInstance(first.getClass(), 3);
        array[0] = first;
        array[1] = second;
        array[2] = third;
        return new Ngram(array, 3, 0);
    }

    public static <S extends Comparable<S> & Serializable> Ngram<S> bigram(S[] array, int index) {
        return new Ngram(array, 2, index);
    }

    public static <S extends Comparable<S> & Serializable> Ngram<S> trigram(S[] array, int index) {
        return new Ngram(array, 3, index);
    }

    @Override
    public Ngram<T> tail() {
        if (this.length != 3) {
            throw new UnsupportedOperationException();
        }
        return new Ngram(this.backingArray, 2, this.offset + 1);
    }

    @Override
    public Ngram<T> head() {
        if (this.length != 3) {
            throw new UnsupportedOperationException();
        }
        return new Ngram(this.backingArray, 2, this.offset);
    }

    @Override
    public T getFirst() {
        return this.atIndex(0);
    }

    @Override
    public T getSecond() {
        return this.atIndex(1);
    }

    @Override
    public T getThird() {
        if (this.length != 3) {
            throw new UnsupportedOperationException();
        }
        return this.atIndex(2);
    }

    private T atIndex(int index) {
        return this.backingArray[this.offset + index];
    }

    @Override
    public int compareTo(Ngram<T> o) {
        int compare = Integer.compare(this.length, o.length);
        if (compare != 0) {
            return compare;
        }
        for (int i = 0; i < this.length; ++i) {
            compare = this.atIndex(i).compareTo(super.atIndex(i));
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index != Ngram.this.length;
            }

            @Override
            public T next() {
                if (this.index == Ngram.this.length) {
                    throw new NoSuchElementException();
                }
                return Ngram.this.atIndex(this.index++);
            }
        };
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ngram ngram = (Ngram)o;
        if (this.length != ngram.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.atIndex(i).equals(ngram.atIndex(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.length; ++i) {
            hashCode = 31 * hashCode + this.atIndex(i).hashCode();
        }
        return hashCode;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.offset = 0;
        Class componentType = (Class)is.readObject();
        this.length = is.readInt();
        Comparable[] array = (Comparable[])Array.newInstance(componentType, this.length);
        this.backingArray = array;
        for (int i = 0; i < this.length; ++i) {
            Comparable t = (Comparable)is.readObject();
            this.backingArray[i] = t;
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        Class<?> componentType = this.backingArray.getClass().getComponentType();
        os.writeObject(componentType);
        os.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            os.writeObject(this.atIndex(i));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (this.length > 0) {
            sb.append(this.atIndex(0).toString());
        }
        for (int i = 1; i < this.length; ++i) {
            sb.append(", ").append(this.atIndex(i).toString());
        }
        return sb.append("]").toString();
    }
}

