/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.statistics;

public class ConfusionMatrix {
    private long truePositives;
    private long falsePositives;
    private long falseNegatives;
    private long trueNegatives;

    public ConfusionMatrix(long truePositives, long falsePositives, long falseNegatives, long trueNegatives) {
        this.truePositives = truePositives;
        this.falsePositives = falsePositives;
        this.falseNegatives = falseNegatives;
        this.trueNegatives = trueNegatives;
    }

    public ConfusionMatrix(ConfusionMatrix confusionMatrix) {
        this.truePositives = confusionMatrix.truePositives;
        this.falsePositives = confusionMatrix.falsePositives;
        this.falseNegatives = confusionMatrix.falseNegatives;
        this.trueNegatives = confusionMatrix.trueNegatives;
    }

    public ConfusionMatrix() {
        this(0L, 0L, 0L, 0L);
    }

    public long getTruePositives() {
        return this.truePositives;
    }

    public long getFalsePositives() {
        return this.falsePositives;
    }

    public long getFalseNegatives() {
        return this.falseNegatives;
    }

    public long getTrueNegatives() {
        return this.trueNegatives;
    }

    public void incrementTruePositives() {
        this.truePositives = Math.incrementExact(this.truePositives);
    }

    public void incrementTruePositives(long count) {
        this.truePositives = Math.addExact(this.truePositives, count);
    }

    public void incrementFalsePositives() {
        this.falsePositives = Math.incrementExact(this.falsePositives);
    }

    public void incrementFalsePositives(long count) {
        this.falsePositives = Math.addExact(this.falsePositives, count);
    }

    public void incrementFalseNegatives() {
        this.falseNegatives = Math.incrementExact(this.falseNegatives);
    }

    public void incrementFalseNegatives(long count) {
        this.falseNegatives = Math.addExact(this.falseNegatives, count);
    }

    public void incrementTrueNegatives() {
        this.trueNegatives = Math.incrementExact(this.trueNegatives);
    }

    public void incrementTrueNegatives(long count) {
        this.trueNegatives = Math.addExact(this.trueNegatives, count);
    }

    public double getPrecision() {
        return (double)this.truePositives / (double)Math.addExact(this.truePositives, this.falsePositives);
    }

    public double getRecall() {
        return (double)this.truePositives / (double)Math.addExact(this.truePositives, this.falseNegatives);
    }

    public double getFScore() {
        return 2.0 * (double)this.truePositives / (2.0 * (double)this.truePositives + (double)Math.addExact(this.falsePositives, this.falseNegatives));
    }

    public void add(ConfusionMatrix confusionMatrix) {
        this.truePositives = Math.addExact(this.truePositives, confusionMatrix.truePositives);
        this.falsePositives = Math.addExact(this.falsePositives, confusionMatrix.falsePositives);
        this.falseNegatives = Math.addExact(this.falseNegatives, confusionMatrix.falseNegatives);
        this.trueNegatives = Math.addExact(this.trueNegatives, confusionMatrix.trueNegatives);
    }
}

