/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.tuples;

import java.io.Serializable;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class Pair<T, U>
implements Serializable {
    private final T first;
    private final U second;

    public Pair(@Nonnull T first, @Nonnull U second) {
        this.first = first;
        this.second = second;
    }

    public static <T, U> Pair<T, U> of(T first, U second) {
        return new Pair<T, U>(first, second);
    }

    @Nonnull
    public T getFirst() {
        return this.first;
    }

    @Nonnull
    public T first() {
        return this.first;
    }

    @Nonnull
    public U getSecond() {
        return this.second;
    }

    @Nonnull
    public U second() {
        return this.second;
    }

    public Pair<U, T> swap() {
        return new Pair<U, T>(this.second, this.first);
    }

    public void call(BiConsumer<T, U> function) {
        function.accept(this.first, this.second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (!this.first.equals(pair.first)) {
            return false;
        }
        return this.second.equals(pair.second);
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        return result;
    }
}

