/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.tuples;

import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class PosCap
implements Comparable<PosCap>,
Serializable {
    private static final long serialVersionUID = -6706873411087752899L;
    private final PartOfSpeech partOfSpeech;
    private final boolean capitalized;

    private PosCap(PartOfSpeech partOfSpeech, boolean capitalized) {
        this.partOfSpeech = Objects.requireNonNull(partOfSpeech);
        this.capitalized = capitalized;
    }

    public static PosCap getCapitalized(PartOfSpeech partOfSpeech) {
        return new PosCap(partOfSpeech, true);
    }

    public static PosCap getNotCapitalized(PartOfSpeech partOfSpeech) {
        return new PosCap(partOfSpeech, false);
    }

    public static PosCap create(PartOfSpeech partOfSpeech, boolean capitalized) {
        return new PosCap(partOfSpeech, capitalized);
    }

    public static int cardinality() {
        return PartOfSpeech.values().length * 2;
    }

    public static PosCap createFromOrdinal(int ordinal) {
        int posOrdinal = ordinal % PartOfSpeech.values().length;
        boolean capitalized = ordinal != posOrdinal;
        return PosCap.create(PartOfSpeech.values()[posOrdinal], capitalized);
    }

    public PartOfSpeech getPartOfSpeech() {
        return this.partOfSpeech;
    }

    public boolean isCapitalized() {
        return this.capitalized;
    }

    public int ordinal() {
        return (this.capitalized ? PartOfSpeech.values().length : 0) + this.partOfSpeech.ordinal();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PosCap that = (PosCap)o;
        if (this.capitalized != that.capitalized) {
            return false;
        }
        return this.partOfSpeech == that.partOfSpeech;
    }

    public int hashCode() {
        int result = this.partOfSpeech.hashCode();
        result = 31 * result + (this.capitalized ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(PosCap o) {
        int result = this.partOfSpeech.compareTo(o.getPartOfSpeech());
        if (result == 0) {
            result = Boolean.compare(this.capitalized, o.isCapitalized());
        }
        return result;
    }

    public String toString() {
        return "PosCap{partOfSpeech=" + this.partOfSpeech.toString() + ", capitalized=" + this.capitalized + '}';
    }
}

