/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.tuples;

import java.io.Serializable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class WordCap
implements Comparable<WordCap>,
Serializable {
    private static final long serialVersionUID = -5981094615088473604L;
    private static final Pattern DIGITS = Pattern.compile("\\d");
    private final String word;
    private final boolean isCapitalized;

    public WordCap(String word, boolean isCapitalized) {
        this.word = word;
        this.isCapitalized = isCapitalized;
    }

    public String getWord() {
        return this.word;
    }

    public boolean isCapitalized() {
        return this.isCapitalized;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordCap wordCap = (WordCap)o;
        if (this.isCapitalized != wordCap.isCapitalized) {
            return false;
        }
        return this.word.equals(wordCap.word);
    }

    public int hashCode() {
        int result = this.word.hashCode();
        result = 31 * result + (this.isCapitalized ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(WordCap o) {
        int result = this.word.compareTo(o.word);
        if (result == 0) {
            result = Boolean.compare(this.isCapitalized, o.isCapitalized);
        }
        return result;
    }

    public String toString() {
        return "WordCap{word='" + this.word + '\'' + ", isCapitalized=" + this.isCapitalized + '}';
    }
}

