/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.tuples;

import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class WordPos
implements Comparable<WordPos>,
Serializable {
    private static final long serialVersionUID = 996488464101266546L;
    private String word;
    private PartOfSpeech tag;

    public WordPos() {
    }

    public WordPos(String word, PartOfSpeech tag) {
        this.word = Objects.requireNonNull(word);
        this.tag = Objects.requireNonNull(tag);
    }

    public WordPos forward() {
        return new WordPos(this.word.substring(1), this.tag);
    }

    public String getWord() {
        return this.word;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public PartOfSpeech getTag() {
        return this.tag;
    }

    public void setTag(PartOfSpeech tag) {
        this.tag = tag;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordPos that = (WordPos)o;
        if (!this.word.equals(that.word)) {
            return false;
        }
        return this.tag == that.tag;
    }

    public int hashCode() {
        int result = this.word.hashCode();
        result = 31 * result + this.tag.hashCode();
        return result;
    }

    @Override
    public int compareTo(WordPos o) {
        int result = this.word.compareTo(o.word);
        if (result == 0) {
            result = this.tag.compareTo(o.tag);
        }
        return result;
    }

    public String toString() {
        return "WordPos{word='" + this.word + '\'' + ", tag=" + this.tag.toString() + '}';
    }
}

