/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.tuples;

import edu.umn.biomedicus.common.tuples.PosCap;
import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import java.io.Serializable;
import javax.annotation.Nullable;

public class WordPosCap
implements Comparable<WordPosCap>,
Serializable {
    private static final long serialVersionUID = 8141457560938728230L;
    private final String word;
    private final PartOfSpeech partOfSpeech;
    private final boolean isCapitalized;

    public WordPosCap(String word, PartOfSpeech partOfSpeech, boolean isCapitalized) {
        this.word = word;
        this.partOfSpeech = partOfSpeech;
        this.isCapitalized = isCapitalized;
    }

    public String getWord() {
        return this.word;
    }

    public PartOfSpeech getPartOfSpeech() {
        return this.partOfSpeech;
    }

    public boolean isCapitalized() {
        return this.isCapitalized;
    }

    public PosCap toPosCap() {
        return PosCap.create(this.partOfSpeech, this.isCapitalized);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordPosCap that = (WordPosCap)o;
        if (!this.word.equals(that.word)) {
            return false;
        }
        if (!this.partOfSpeech.equals((Object)that.partOfSpeech)) {
            return false;
        }
        return this.isCapitalized == that.isCapitalized;
    }

    public int hashCode() {
        int result = this.word.hashCode();
        result = 31 * result + this.partOfSpeech.hashCode();
        result = 31 * result + Boolean.hashCode(this.isCapitalized);
        return result;
    }

    @Override
    public int compareTo(WordPosCap o) {
        int result = this.word.compareTo(o.word);
        if (result == 0) {
            result = this.partOfSpeech.compareTo(o.partOfSpeech);
        }
        if (result == 0) {
            result = Boolean.compare(this.isCapitalized, o.isCapitalized);
        }
        return result;
    }

    public String toString() {
        return "WordPosCap{word='" + this.word + '\'' + ", partOfSpeech=" + this.partOfSpeech.toString() + ", isCapitalized=" + this.isCapitalized + '}';
    }
}

