/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.types.syntax;

import edu.umn.biomedicus.common.types.syntax.PartOfSpeech;
import edu.umn.biomedicus.common.types.syntax.UniversalPartOfSpeech;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class PartsOfSpeech {
    private static final Map<String, PartOfSpeech> MAP = PartsOfSpeech.buildMap();
    private static final Map<String, PartOfSpeech> FALLBACK_MAP = PartsOfSpeech.buildFallbackMap();
    private static final Set<PartOfSpeech> PUNCTUATION_CLASS = PartsOfSpeech.buildPunctuationClass();
    private static final Set<PartOfSpeech> OPEN_CLASS = PartsOfSpeech.buildOpenClass();
    private static final Set<PartOfSpeech> REAL_TAGS = PartsOfSpeech.buildRealTags();
    private static final Set<UniversalPartOfSpeech> UNIVERSAL_OPEN_CLASS = PartsOfSpeech.buildUniversalOpenClass();
    private static final Set<UniversalPartOfSpeech> UNIVERSAL_CLOSED_CLASS = PartsOfSpeech.buildUniversalClosedClass();

    private PartsOfSpeech() {
        throw new UnsupportedOperationException("Instantiation of utility class.");
    }

    private static Map<String, PartOfSpeech> buildMap() {
        HashMap<String, PartOfSpeech> builder = new HashMap<String, PartOfSpeech>();
        for (PartOfSpeech partOfSpeech : PartOfSpeech.values()) {
            builder.put(partOfSpeech.toString(), partOfSpeech);
        }
        return Collections.unmodifiableMap(builder);
    }

    private static Map<String, PartOfSpeech> buildFallbackMap() {
        HashMap<String, PartOfSpeech> builder = new HashMap<String, PartOfSpeech>();
        for (PartOfSpeech partOfSpeech : PartOfSpeech.values()) {
            builder.put(partOfSpeech.toString(), partOfSpeech);
        }
        builder.put("N", PartOfSpeech.NN);
        builder.put("NP", PartOfSpeech.NNP);
        builder.put("NPS", PartOfSpeech.NNPS);
        builder.put("PP", PartOfSpeech.PRP);
        builder.put("PP$", PartOfSpeech.PRP$);
        builder.put("-", PartOfSpeech.HYPH);
        builder.put("--", PartOfSpeech.COLON_PUNCTUATION);
        builder.put(null, PartOfSpeech.XX);
        builder.put("null", PartOfSpeech.XX);
        builder.put("", PartOfSpeech.XX);
        builder.put("X", PartOfSpeech.XX);
        builder.put("\u201c", PartOfSpeech.OPENING_QUOTATION);
        builder.put("\u201d", PartOfSpeech.CLOSING_QUOTATION);
        builder.put("\u2018", PartOfSpeech.OPENING_SINGLE_QUOTE);
        builder.put("\u2019", PartOfSpeech.CLOSING_SINGLE_QUOTE);
        builder.put("\u2033", PartOfSpeech.STRAIGHT_DOUBLE_QUOTE);
        builder.put("-LRB-", PartOfSpeech.LEFT_PAREN);
        builder.put("-RRB-", PartOfSpeech.RIGHT_PAREN);
        builder.put(";", PartOfSpeech.COLON_PUNCTUATION);
        builder.put("?", PartOfSpeech.SENTENCE_CLOSER_PUNCTUATION);
        return Collections.unmodifiableMap(builder);
    }

    private static Set<PartOfSpeech> buildPunctuationClass() {
        EnumSet<PartOfSpeech[]> punc = EnumSet.of(PartOfSpeech.SENTENCE_CLOSER_PUNCTUATION, new PartOfSpeech[]{PartOfSpeech.COMMA_PUNCTUATION, PartOfSpeech.COLON_PUNCTUATION, PartOfSpeech.LEFT_PAREN, PartOfSpeech.RIGHT_PAREN, PartOfSpeech.OPENING_QUOTATION, PartOfSpeech.CLOSING_QUOTATION, PartOfSpeech.OPENING_SINGLE_QUOTE, PartOfSpeech.CLOSING_SINGLE_QUOTE, PartOfSpeech.STRAIGHT_DOUBLE_QUOTE, PartOfSpeech.HYPH, PartOfSpeech.POUND_SIGN, PartOfSpeech.DOLLAR_SIGN});
        return Collections.unmodifiableSet(punc);
    }

    private static Set<PartOfSpeech> buildOpenClass() {
        EnumSet<PartOfSpeech[]> open = EnumSet.of(PartOfSpeech.JJ, new PartOfSpeech[]{PartOfSpeech.JJR, PartOfSpeech.JJS, PartOfSpeech.NN, PartOfSpeech.NNP, PartOfSpeech.NNPS, PartOfSpeech.RB, PartOfSpeech.RBR, PartOfSpeech.RBS, PartOfSpeech.VB, PartOfSpeech.VBD, PartOfSpeech.VBG, PartOfSpeech.VBN, PartOfSpeech.VBP, PartOfSpeech.VBZ});
        return Collections.unmodifiableSet(open);
    }

    private static Set<PartOfSpeech> buildRealTags() {
        EnumSet<PartOfSpeech> reals = EnumSet.allOf(PartOfSpeech.class);
        reals.remove((Object)PartOfSpeech.XX);
        reals.remove((Object)PartOfSpeech.BBS);
        reals.remove((Object)PartOfSpeech.BOS);
        reals.remove((Object)PartOfSpeech.EOS);
        return Collections.unmodifiableSet(reals);
    }

    private static Set<UniversalPartOfSpeech> buildUniversalOpenClass() {
        EnumSet<UniversalPartOfSpeech[]> openClass = EnumSet.of(UniversalPartOfSpeech.ADJ, new UniversalPartOfSpeech[]{UniversalPartOfSpeech.ADV, UniversalPartOfSpeech.INTJ, UniversalPartOfSpeech.NOUN, UniversalPartOfSpeech.PROPN, UniversalPartOfSpeech.VERB});
        return Collections.unmodifiableSet(openClass);
    }

    private static Set<UniversalPartOfSpeech> buildUniversalClosedClass() {
        EnumSet<UniversalPartOfSpeech[]> closedClass = EnumSet.of(UniversalPartOfSpeech.ADP, new UniversalPartOfSpeech[]{UniversalPartOfSpeech.AUX, UniversalPartOfSpeech.CONJ, UniversalPartOfSpeech.DET, UniversalPartOfSpeech.NUM, UniversalPartOfSpeech.PART, UniversalPartOfSpeech.PRON, UniversalPartOfSpeech.SCONJ});
        return Collections.unmodifiableSet(closedClass);
    }

    public static PartOfSpeech forTag(String tag) {
        if (!MAP.containsKey(tag)) {
            throw new IllegalArgumentException("Part of speech not found: " + tag);
        }
        return MAP.get(tag);
    }

    public static Optional<PartOfSpeech> forTagWithFallback(String tag) {
        PartOfSpeech partOfSpeech = MAP.get(tag);
        if (partOfSpeech != null) {
            return Optional.of(partOfSpeech);
        }
        return Optional.ofNullable(FALLBACK_MAP.get(tag));
    }

    public static String tagForPartOfSpeech(PartOfSpeech partOfSpeech) {
        return partOfSpeech.toString();
    }

    public static Set<UniversalPartOfSpeech> getUniversalOpenClass() {
        return UNIVERSAL_OPEN_CLASS;
    }

    public static Set<UniversalPartOfSpeech> getUniversalClosedClass() {
        return UNIVERSAL_CLOSED_CLASS;
    }

    public static Set<PartOfSpeech> getOpenClass() {
        return OPEN_CLASS;
    }

    public static Set<PartOfSpeech> getRealTags() {
        return REAL_TAGS;
    }

    public static Set<PartOfSpeech> getPunctuationClass() {
        return PUNCTUATION_CLASS;
    }

    public static UniversalPartOfSpeech universalForTag(String tag) {
        return UniversalPartOfSpeech.valueOf(tag);
    }
}

