/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.utilities;

import edu.umn.biomedicus.exc.BiomedicusException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Patterns {
    public static final Pattern NON_WHITESPACE = Pattern.compile("\\S");
    public static final Pattern ALPHABETIC_WORD = Pattern.compile("[\\p{L}]+");
    public static final Pattern ALPHANUMERIC_WORD = Pattern.compile("[\\p{L}\\p{Nd}]+");
    public static final Pattern A_LETTER_OR_NUMBER = Pattern.compile("[\\p{Nd}\\p{L}]");
    public static final Pattern NEWLINE = Pattern.compile("\n");
    public static final Pattern INITIAL_WHITESPACE = Pattern.compile("^\\s+");
    public static final Pattern FINAL_WHITESPACE = Pattern.compile("\\s+$");

    private Patterns() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pattern loadPatternByJoiningLines(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(resourceName)));){
            Pattern pattern = Patterns.getPattern(reader);
            return pattern;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Pattern getPattern(BufferedReader reader) {
        return Pattern.compile(reader.lines().collect(Collectors.joining("|")), 9);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Pattern loadPatternByJoiningLines(Path path) throws BiomedicusException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Pattern pattern = Patterns.getPattern(reader);
            return pattern;
        }
        catch (IOException e) {
            throw new BiomedicusException("Failed to load pattern.", e);
        }
    }
}

