/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.viterbi;

import edu.umn.biomedicus.common.grams.Bigram;
import edu.umn.biomedicus.common.viterbi.HistoryChain;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

class Ancestor<S> {
    private final double logProbability;
    private final HistoryChain<S> historyChain;
    @Nullable
    private BiFunction<S, S, Bigram<S>> bigramProvider;

    private Ancestor(double logProbability, HistoryChain<S> historyChain, @Nullable BiFunction<S, S, Bigram<S>> bigramProvider) {
        this.logProbability = logProbability;
        this.historyChain = historyChain;
        this.bigramProvider = bigramProvider;
    }

    static <S> Ancestor<S> createInitial(Iterable<S> states, @Nullable BiFunction<S, S, Bigram<S>> bigramProvider) {
        HistoryChain<S> history = null;
        boolean atLeastOne = false;
        for (S state : states) {
            atLeastOne = true;
            history = new HistoryChain<S>(history, state);
        }
        if (!atLeastOne) {
            throw new IllegalArgumentException("there should be at least one initial state");
        }
        return new Ancestor<S>(0.0, history, bigramProvider);
    }

    @SafeVarargs
    static <S> Ancestor<S> createInitial(@Nullable BiFunction<S, S, Bigram<S>> bigramProvider, S ... states) {
        return Ancestor.createInitial(() -> Arrays.stream(states).iterator(), bigramProvider);
    }

    static <S> Ancestor<S> moreProbable(Ancestor<S> first, Ancestor<S> second) {
        return first.logProbability > second.logProbability ? first : second;
    }

    double getLogProbability() {
        return this.logProbability;
    }

    List<S> getHistory(S skipValue) {
        LinkedList<S> history = new LinkedList<S>();
        for (HistoryChain<S> pointer = this.historyChain; pointer != null; pointer = pointer.getPrevious()) {
            S payload = pointer.getState();
            if (payload == null) {
                payload = skipValue;
            }
            history.addFirst(payload);
        }
        return history;
    }

    Ancestor<S> createDescendant(double logProbability, S state) {
        return new Ancestor<S>(logProbability, this.historyChain.append(state), this.bigramProvider);
    }

    Ancestor<S> skip() {
        return new Ancestor<S>(this.logProbability, this.historyChain.skip(), this.bigramProvider);
    }

    Bigram<S> getBigram() {
        Objects.requireNonNull(this.bigramProvider);
        return this.bigramProvider.apply(this.historyChain.getNonnullPayload(1), this.historyChain.getNonnullPayload(0));
    }

    S mostRecent() {
        return this.historyChain.getNonnullPayload(0);
    }
}

