/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.viterbi;

import java.util.NoSuchElementException;
import javax.annotation.Nullable;

class HistoryChain<S> {
    @Nullable
    private final HistoryChain<S> previous;
    @Nullable
    private final S state;

    HistoryChain(@Nullable HistoryChain<S> previous, @Nullable S state) {
        this.previous = previous;
        this.state = state;
    }

    HistoryChain<S> append(S state) {
        return new HistoryChain<S>(this, state);
    }

    HistoryChain<S> skip() {
        return new HistoryChain<Object>(this, null);
    }

    S getNonnullPayload(int fromThis) {
        HistoryChain<S> pointer = this;
        int counter = 0;
        while (counter < fromThis || pointer.state == null) {
            if (pointer.state != null) {
                ++counter;
            }
            if ((pointer = pointer.previous) != null) continue;
            throw new NoSuchElementException();
        }
        return pointer.state;
    }

    @Nullable
    S getState() {
        return this.state;
    }

    @Nullable
    HistoryChain<S> getPrevious() {
        return this.previous;
    }
}

