/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.viterbi;

import edu.umn.biomedicus.common.grams.Bigram;
import edu.umn.biomedicus.common.viterbi.Ancestor;
import edu.umn.biomedicus.common.viterbi.CandidateProbability;
import edu.umn.biomedicus.common.viterbi.EmissionProbabilityModel;
import edu.umn.biomedicus.common.viterbi.SimpleCandidateProbability;
import edu.umn.biomedicus.common.viterbi.TransitionProbabilityModel;
import edu.umn.biomedicus.common.viterbi.ViterbiProcessor;
import edu.umn.biomedicus.common.viterbi.ViterbiProcessorImpl;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;

public final class Viterbi {
    private Viterbi() {
        throw new UnsupportedOperationException();
    }

    public static <S, Y> ViterbiProcessor<S, Y> firstOrder(EmissionProbabilityModel<S, Y> emissionProbabilityModel, TransitionProbabilityModel<S, S> transitionProbabilityModel, S initialState) {
        Ancestor<Object> initial = Ancestor.createInitial(null, initialState);
        Set ancestors = Collections.singleton(initial);
        return new ViterbiProcessorImpl<S, Y, Object>(emissionProbabilityModel, transitionProbabilityModel, Ancestor::mostRecent, ancestors);
    }

    public static <S, Y> ViterbiProcessor<S, Y> secondOrder(EmissionProbabilityModel<S, Y> emissionModel, TransitionProbabilityModel<S, Bigram<S>> transitionModel, Bigram<S> initialStates, BiFunction<S, S, Bigram<S>> bigramProvider) {
        Ancestor<S> initial = Ancestor.createInitial(initialStates, bigramProvider);
        Set<Ancestor<S>> ancestors = Collections.singleton(initial);
        return new ViterbiProcessorImpl<S, Y, Bigram>(emissionModel, transitionModel, Ancestor::getBigram, ancestors);
    }

    public static <S> CandidateProbability<S> candidateOf(S candidate, double emissionLogProbability) {
        return new SimpleCandidateProbability<S>(candidate, emissionLogProbability);
    }
}

