/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.common.viterbi;

import edu.umn.biomedicus.common.viterbi.Ancestor;
import edu.umn.biomedicus.common.viterbi.CandidateProbability;
import edu.umn.biomedicus.common.viterbi.EmissionProbabilityModel;
import edu.umn.biomedicus.common.viterbi.TransitionProbabilityModel;
import edu.umn.biomedicus.common.viterbi.ViterbiProcessor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ViterbiProcessorImpl<S, Y, R>
implements ViterbiProcessor<S, Y> {
    private final EmissionProbabilityModel<S, Y> emissionProbabilityModel;
    private final TransitionProbabilityModel<S, R> transitionProbabilityModel;
    private final Function<Ancestor<S>, R> reducer;
    private Collection<Ancestor<S>> ancestors;

    ViterbiProcessorImpl(EmissionProbabilityModel<S, Y> emissionProbabilityModel, TransitionProbabilityModel<S, R> transitionProbabilityModel, Function<Ancestor<S>, R> reducer, Collection<Ancestor<S>> ancestors) {
        this.emissionProbabilityModel = emissionProbabilityModel;
        this.transitionProbabilityModel = transitionProbabilityModel;
        this.reducer = reducer;
        this.ancestors = ancestors;
    }

    @Override
    public void advance(Y emittedValue) {
        Stream<CandidateProbability<S>> candidateProbabilityStream = this.emissionProbabilityModel.getCandidates(emittedValue).stream();
        Stream<Function> transitionFunctionStream = candidateProbabilityStream.map(candidate -> ancestor -> {
            Object candidateState = candidate.getCandidate();
            double transitionLogProbability = this.transitionProbabilityModel.getTransitionLogProbability(this.reducer.apply((Ancestor<S>)ancestor), candidateState);
            double logProbability = transitionLogProbability + candidate.getEmissionLogProbability() + ancestor.getLogProbability();
            return ancestor.createDescendant(logProbability, candidateState);
        });
        Stream potentialAncestorStream = transitionFunctionStream.flatMap(f -> this.ancestors.stream().map(f::apply));
        Stream<Ancestor> filteredAncestorStream = potentialAncestorStream.filter(s -> s.getLogProbability() > Double.NEGATIVE_INFINITY);
        Map<R, Ancestor> ancestorByStateMap = filteredAncestorStream.collect(Collectors.toMap(this.reducer, ancestor -> ancestor, Ancestor::moreProbable));
        Collection<Ancestor> candidates = ancestorByStateMap.values();
        this.ancestors = candidates.size() > 0 ? candidates : (Collection)this.ancestors.stream().map(Ancestor::skip).collect(Collectors.toList());
    }

    @Override
    public void beamFilter(double beamThreshold) {
        if (this.ancestors.size() < 10) {
            return;
        }
        double logGreatest = this.ancestors.stream().mapToDouble(Ancestor::getLogProbability).max().getAsDouble();
        double logBoundary = logGreatest - beamThreshold;
        this.ancestors = this.ancestors.stream().filter(s -> s.getLogProbability() >= logBoundary).collect(Collectors.toList());
        if (this.ancestors.size() == 0) {
            throw new AssertionError((Object)"Number of ancestors should never drop to zero");
        }
    }

    @Override
    public List<S> end(S skipValue, S terminalValue) {
        double maxLogProb = Double.NEGATIVE_INFINITY;
        Ancestor<S> maxProbState = null;
        for (Ancestor<S> ancestor : this.ancestors) {
            double trigramProbability = this.transitionProbabilityModel.getTransitionLogProbability(this.reducer.apply(ancestor), terminalValue);
            double logProbability = ancestor.getLogProbability() + Math.log10(trigramProbability);
            if (!(logProbability > maxLogProb)) continue;
            maxLogProb = logProbability;
            maxProbState = ancestor;
        }
        if (maxProbState == null) {
            for (Ancestor<S> state : this.ancestors) {
                double logProbability = state.getLogProbability();
                if (!(logProbability > maxLogProb)) continue;
                maxLogProb = logProbability;
                maxProbState = state;
            }
            if (maxProbState == null) {
                throw new AssertionError((Object)"0-probability result");
            }
        }
        return maxProbState.getHistory(skipValue);
    }
}

