/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.concepts;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class CUI
implements Serializable {
    public static final Pattern CUI_PATTERN = Pattern.compile("C([\\d]{7})");
    private final int identifier;

    public CUI(int identifier) {
        this.identifier = identifier;
    }

    public CUI(String wordForm) {
        Matcher matcher = CUI_PATTERN.matcher(wordForm);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Word form does not match CUI pattern");
        }
        String identifier = matcher.group(1);
        this.identifier = Integer.parseInt(identifier);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CUI cui = (CUI)o;
        return this.identifier == cui.identifier;
    }

    public int hashCode() {
        return this.identifier;
    }

    public String toString() {
        return String.format("C%07d", this.identifier);
    }

    public int identifier() {
        return this.identifier;
    }
}

