/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.concepts;

import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.Module;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.dictionary.BidirectionalDictionary;
import edu.umn.biomedicus.common.dictionary.StringsBag;
import edu.umn.biomedicus.concepts.CUI;
import edu.umn.biomedicus.concepts.ConceptRow;
import edu.umn.biomedicus.concepts.SUI;
import edu.umn.biomedicus.concepts.TUI;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.Bootstrapper;
import edu.umn.biomedicus.vocabulary.Vocabulary;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.spi.PathOptionHandler;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptDictionaryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConceptDictionaryBuilder.class);
    private static final Pattern SPLITTER = Pattern.compile("\\|");
    private static final Pattern SPACE_SPLITTER = Pattern.compile(" ");
    private final Set<SUI> filteredSuis;
    private final Set<CUI> filteredCuis;
    private final Set<SuiCui> filteredSuiCuis;
    private final Set<TUI> filteredTuis;
    private final Vocabulary vocabulary;
    @Nullable
    @Argument(required=true, handler=PathOptionHandler.class, usage="Path to UMLS installation")
    private Path umlsPath;
    @Nullable
    @Argument(index=1, required=true, handler=PathOptionHandler.class, usage="Path to TUIs of interest")
    private Path tuisOfInterestFile;
    @Nullable
    @Argument(index=2, required=true, handler=PathOptionHandler.class, usage="Banned TTYs file")
    private Path bannedTtysFile;
    @Nullable
    @Argument(index=3, handler=PathOptionHandler.class, usage="Path to write db out to.")
    private Path dbPath;

    @Inject
    ConceptDictionaryBuilder(@Setting(value="concepts.filters.sui.asDataPath") Path filteredSuisPath, @Setting(value="concepts.filters.cui.asDataPath") Path filteredCuisPath, @Setting(value="concepts.filters.suicui.asDataPath") Path filteredSuiCuisPath, @Setting(value="concepts.filters.tui.asDataPath") Path filteredTuisPath, Vocabulary vocabulary) throws IOException {
        Pattern splitter = Pattern.compile(",");
        this.filteredSuis = Files.lines(filteredSuisPath).map(SUI::new).collect(Collectors.toSet());
        this.filteredCuis = Files.lines(filteredCuisPath).map(CUI::new).collect(Collectors.toSet());
        this.filteredSuiCuis = Files.lines(filteredSuiCuisPath).map(splitter::split).map(line -> new SuiCui(new SUI(line[0]), new CUI(line[1]))).collect(Collectors.toSet());
        this.filteredTuis = Files.lines(filteredTuisPath).map(TUI::new).collect(Collectors.toSet());
        this.vocabulary = vocabulary;
    }

    public static void main(String[] args) {
        try {
            Bootstrapper.create(new Module[0]).getInstance(ConceptDictionaryBuilder.class).doWork(args);
        }
        catch (BiomedicusException | IOException e) {
            e.printStackTrace();
        }
    }

    private void doWork(String[] args) throws IOException {
        Throwable throwable;
        Serializable cui2;
        RocksDB.loadLibrary();
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getLocalizedMessage());
            System.err.println("java edu.umn.biomedicus.concepts.ConceptDictionaryBuilder [umls path] [tuis of interest path] [banned ttys path] [output path]");
            parser.printUsage((OutputStream)System.err);
            return;
        }
        if (Files.exists(this.dbPath, new LinkOption[0])) {
            Files.deleteIfExists(this.dbPath.resolve("phrases"));
            Files.deleteIfExists(this.dbPath.resolve("lowercase"));
            Files.deleteIfExists(this.dbPath.resolve("norms"));
        }
        System.out.println("Loading TUIs of interest");
        Set whitelist = Files.lines(this.tuisOfInterestFile).map(SPLITTER::split).filter(line -> ((String[])line).length >= 3).map(line -> line[1]).map(TUI::new).collect(Collectors.toSet());
        Set ttyBanlist = Files.lines(this.bannedTtysFile).collect(Collectors.toSet());
        Path mrstyPath = this.umlsPath.resolve("MRSTY.RRF");
        System.out.println("Loading CUI -> TUIs map from MRSTY: " + mrstyPath);
        Map<CUI, List> cuiToTUIs = Files.lines(mrstyPath).map(SPLITTER::split).map(line -> {
            CUI cui = new CUI(line[0]);
            TUI tui = new TUI(line[1]);
            ArrayList<TUI> tuis = new ArrayList<TUI>();
            if (whitelist.contains(tui)) {
                tuis.add(tui);
                return new AbstractMap.SimpleImmutableEntry(cui, tuis);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (firstList, secondList) -> {
            for (TUI tui : secondList) {
                if (firstList.contains(tui)) continue;
                firstList.add(tui);
            }
            return firstList;
        }));
        BidirectionalDictionary normIndex = this.vocabulary.getWordsIndex();
        Path mrconsoPath = this.umlsPath.resolve("MRCONSO.RRF");
        System.out.println("Loading phrases and SUI -> CUIs from MRCONSO: " + mrconsoPath);
        HashSet<SUI> bannedSUIs = new HashSet<SUI>();
        HashMap<String, Integer> sources = new HashMap<String, Integer>();
        HashMap suiCuiSources = new HashMap();
        Files.createDirectories(this.dbPath, new FileAttribute[0]);
        long mrConsoTotalLines = Files.lines(mrconsoPath).count();
        int mrConsoCompletedLines = 0;
        TreeMap phrasesMap = new TreeMap();
        TreeMap lowercaseMap = new TreeMap();
        try (BufferedReader bufferedReader = Files.newBufferedReader(mrconsoPath);){
            Object tty;
            Object obsoleteOrSuppressible;
            String line2;
            while ((line2 = bufferedReader.readLine()) != null) {
                if (++mrConsoCompletedLines % 10000 == 0) {
                    System.out.println("Read " + mrConsoCompletedLines + " of " + mrConsoTotalLines);
                }
                String[] splitLine = SPLITTER.split(line2);
                cui2 = new CUI(splitLine[0]);
                if (!"ENG".equals(splitLine[1])) continue;
                SUI sui = new SUI(splitLine[5]);
                obsoleteOrSuppressible = splitLine[16];
                String source2 = splitLine[11];
                tty = splitLine[12];
                String phrase = splitLine[14];
                if (phrase.length() < 3) continue;
                if (!"N".equals(obsoleteOrSuppressible)) {
                    bannedSUIs.add(sui);
                    continue;
                }
                if (ttyBanlist.contains(tty)) {
                    bannedSUIs.add(sui);
                    continue;
                }
                List tuis = cuiToTUIs.get(cui2);
                if (tuis == null || tuis.size() == 0) {
                    LOGGER.trace("Filtering \"{}\" because it has no interesting types", (Object)phrase);
                    continue;
                }
                Iterator iterator2 = tuis.iterator();
                while (iterator2.hasNext()) {
                    TUI tui = (TUI)iterator2.next();
                    SuiCui sc = new SuiCui(sui, (CUI)cui2);
                    if (this.filteredCuis.contains(cui2) || this.filteredTuis.contains(tui) || this.filteredSuiCuis.contains(sc) || this.filteredSuis.contains(sui)) continue;
                    Integer sourceId = sources.computeIfAbsent(source2, unused -> sources.size());
                    ConceptRow value = new ConceptRow(sui, (CUI)cui2, tui, sourceId);
                    this.multimapPut(phrasesMap, phrase, value);
                    this.multimapPut(lowercaseMap, phrase, value);
                    this.multimapPut(suiCuiSources, sc, sourceId);
                }
            }
            try {
                Options options = new Options().setCreateIfMissing(true).prepareForBulkLoad();
                cui2 = null;
                try {
                    RocksDB phrases = RocksDB.open((Options)options, (String)this.dbPath.resolve("phrases").toString());
                    obsoleteOrSuppressible = null;
                    try {
                        RocksDB lowercase = RocksDB.open((Options)options, (String)this.dbPath.resolve("lowercase").toString());
                        tty = null;
                        try {
                            byte[] suiCuiTuiBytes;
                            List suiCuiTuis;
                            int wrote = 0;
                            for (Map.Entry entry : phrasesMap.entrySet()) {
                                suiCuiTuis = (List)entry.getValue();
                                suiCuiTuiBytes = this.getBytes(suiCuiTuis);
                                phrases.put(((String)entry.getKey()).getBytes(), suiCuiTuiBytes);
                                if (++wrote % 10000 != 0) continue;
                                System.out.println("Wrote " + wrote + " of " + phrasesMap.size() + " phrases");
                            }
                            wrote = 0;
                            for (Map.Entry entry : lowercaseMap.entrySet()) {
                                suiCuiTuis = (List)entry.getValue();
                                suiCuiTuiBytes = this.getBytes(suiCuiTuis);
                                lowercase.put(((String)entry.getKey()).getBytes(), suiCuiTuiBytes);
                                if (++wrote % 10000 != 0) continue;
                                System.out.println("Wrote " + wrote + " of " + lowercaseMap.size() + " lowercase phrases");
                            }
                        }
                        catch (Throwable wrote) {
                            tty = wrote;
                            throw wrote;
                        }
                        finally {
                            if (lowercase != null) {
                                if (tty != null) {
                                    try {
                                        lowercase.close();
                                    }
                                    catch (Throwable wrote) {
                                        ((Throwable)tty).addSuppressed(wrote);
                                    }
                                } else {
                                    lowercase.close();
                                }
                            }
                        }
                    }
                    catch (Throwable lowercase) {
                        obsoleteOrSuppressible = lowercase;
                        throw lowercase;
                    }
                    finally {
                        if (phrases != null) {
                            if (obsoleteOrSuppressible != null) {
                                try {
                                    phrases.close();
                                }
                                catch (Throwable lowercase) {
                                    ((Throwable)obsoleteOrSuppressible).addSuppressed(lowercase);
                                }
                            } else {
                                phrases.close();
                            }
                        }
                    }
                }
                catch (Throwable phrases) {
                    cui2 = phrases;
                    throw phrases;
                }
                finally {
                    if (options != null) {
                        if (cui2 != null) {
                            try {
                                options.close();
                            }
                            catch (Throwable phrases) {
                                ((Throwable)cui2).addSuppressed(phrases);
                            }
                        } else {
                            options.close();
                        }
                    }
                }
            }
            catch (RocksDBException e) {
                e.printStackTrace();
                if (bufferedReader != null) {
                    if (var18_20 != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable cui2) {
                            var18_20.addSuppressed(cui2);
                        }
                    } else {
                        bufferedReader.close();
                    }
                }
                return;
            }
        }
        Path mrxnsPath = this.umlsPath.resolve("MRXNS_ENG.RRF");
        System.out.println("Loading lowercase normalized strings from MRXNS_ENG: " + mrxnsPath);
        int lineCount = 0;
        long totalLines = Files.lines(mrxnsPath).count();
        TreeMap map = new TreeMap();
        BufferedReader bufferedReader = Files.newBufferedReader(mrxnsPath);
        cui2 = null;
        try {
            String line3;
            while ((line3 = bufferedReader.readLine()) != null) {
                Iterable columns;
                Iterator it;
                if (++lineCount % 10000 == 0) {
                    System.out.println("Read " + lineCount + " of " + totalLines);
                }
                if (!"ENG".equals((it = (columns = Splitter.on((String)"|").split((CharSequence)line3)).iterator()).next())) continue;
                List<String> norms = Arrays.asList(SPACE_SPLITTER.split((CharSequence)it.next()));
                CUI cui3 = new CUI((String)it.next());
                it.next();
                SUI sui = new SUI((String)it.next());
                if (norms.size() < 2 || bannedSUIs.contains(sui)) continue;
                StringsBag termsBag = normIndex.getTermsBag(norms);
                List tuis = cuiToTUIs.get(cui3);
                if (tuis == null || tuis.size() == 0) {
                    LOGGER.trace("Filtering \"{}\" because it has no interesting types", (Object)termsBag);
                    continue;
                }
                for (TUI tui : tuis) {
                    SuiCui sc = new SuiCui(sui, cui3);
                    if (this.filteredCuis.contains(cui3) || this.filteredTuis.contains(tui) || this.filteredSuiCuis.contains(sc) || this.filteredSuis.contains(sui)) continue;
                    List sourceList = (List)suiCuiSources.get(sc);
                    for (Integer sourceId : sourceList) {
                        this.multimapPut(map, termsBag, new ConceptRow(sui, cui3, tui, sourceId));
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            cui2 = throwable2;
            throw throwable2;
        }
        finally {
            if (bufferedReader != null) {
                if (cui2 != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)cui2).addSuppressed(throwable3);
                    }
                } else {
                    bufferedReader.close();
                }
            }
        }
        int wrote = 0;
        try {
            throwable = null;
            try (Options options = new Options().setCreateIfMissing(true).prepareForBulkLoad();
                 RocksDB normsDb = RocksDB.open((Options)options, (String)this.dbPath.resolve("norms").toString());){
                for (Map.Entry entry : map.entrySet()) {
                    List suiCuiTuis = (List)entry.getValue();
                    byte[] suiCuiTuiBytes = this.getBytes(suiCuiTuis);
                    normsDb.put(((StringsBag)entry.getKey()).getBytes(), suiCuiTuiBytes);
                    if (++wrote % 10000 != 0) continue;
                    System.out.println("Wrote " + wrote + " of " + map.size() + " norm term bags.");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (RocksDBException e) {
            throw new IllegalStateException(e);
        }
        throwable = null;
        try (BufferedWriter writer = Files.newBufferedWriter(this.dbPath.resolve("sources.txt"), new OpenOption[0]);){
            sources.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).forEach(s -> {
                try {
                    writer.write((String)s);
                    writer.newLine();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
    }

    private byte[] getBytes(List<ConceptRow> rows) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16 * rows.size());
        for (ConceptRow row : rows) {
            byteBuffer.put(row.getBytes());
        }
        return byteBuffer.array();
    }

    private <K, V> void multimapPut(Map<K, List<V>> map, K key, V value) {
        map.compute(key, (unused, v) -> {
            if (v == null) {
                v = new ArrayList<Object>();
            }
            v.add(value);
            return v;
        });
    }

    private static final class SuiCui
    implements Comparable<SuiCui> {
        private final SUI sui;
        private final CUI cui;

        SuiCui(SUI sui, CUI cui) {
            this.sui = sui;
            this.cui = cui;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SuiCui suiCui = (SuiCui)o;
            if (!this.sui.equals(suiCui.sui)) {
                return false;
            }
            return this.cui.equals(suiCui.cui);
        }

        public int hashCode() {
            int result = this.sui.hashCode();
            result = 31 * result + this.cui.hashCode();
            return result;
        }

        @Override
        public int compareTo(@Nonnull SuiCui o) {
            int compare = Integer.compare(this.sui.identifier(), o.sui.identifier());
            if (compare != 0) {
                return compare;
            }
            return Integer.compare(this.cui.identifier(), o.cui.identifier());
        }
    }
}

