/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.concepts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.common.dictionary.StringsBag;
import edu.umn.biomedicus.concepts.ConceptDictionary;
import edu.umn.biomedicus.concepts.ConceptRow;
import edu.umn.biomedicus.concepts.RocksDbConceptDictionary;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConceptDictionaryLoader
extends DataLoader<ConceptDictionary> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConceptDictionaryLoader.class);
    private final Path dbPath;
    private final boolean inMemory;

    @Inject
    ConceptDictionaryLoader(@Setting(value="concepts.db.asDataPath") Path dbPath, @Setting(value="concepts.inMemory") boolean inMemory) {
        this.dbPath = dbPath;
        this.inMemory = inMemory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ConceptDictionary loadModel() throws BiomedicusException {
        RocksDB.loadLibrary();
        try (Options options = new Options().setInfoLogLevel(InfoLogLevel.ERROR_LEVEL);){
            LOGGER.info("Opening concepts dictionary: {}. inMemory = {}.", (Object)this.dbPath, (Object)this.inMemory);
            RocksDB phrasesDB = RocksDB.openReadOnly((Options)options, (String)this.dbPath.resolve("phrases").toString());
            RocksDB lowercaseDB = RocksDB.openReadOnly((Options)options, (String)this.dbPath.resolve("lowercase").toString());
            RocksDB normsDB = RocksDB.openReadOnly((Options)options, (String)this.dbPath.resolve("norms").toString());
            final HashMap<Integer, String> sources = new HashMap<Integer, String>();
            Files.lines(this.dbPath.resolve("sources.txt")).forEach(s -> sources.put(sources.size(), (String)s));
            if (this.inMemory) {
                LOGGER.info("Loading concepts phrases into memory.");
                final HashMap phrases = new HashMap();
                ConceptDictionaryLoader.dumpToMap(phrasesDB, phrases, String::new);
                LOGGER.info("Loading concepts lowercases into memory.");
                final HashMap lowercasePhrases = new HashMap();
                ConceptDictionaryLoader.dumpToMap(lowercaseDB, lowercasePhrases, String::new);
                LOGGER.info("Loading concepts norms into memory.");
                final HashMap normDictionary = new HashMap();
                ConceptDictionaryLoader.dumpToMap(normsDB, normDictionary, StringsBag::new);
                LOGGER.info("Done loading concepts into memory.");
                ConceptDictionary conceptDictionary = new ConceptDictionary(){

                    @Override
                    @Nullable
                    public List<ConceptRow> forPhrase(String phrase) {
                        return (List)phrases.get(phrase);
                    }

                    @Override
                    @Nullable
                    public List<ConceptRow> forLowercasePhrase(String phrase) {
                        return (List)lowercasePhrases.get(phrase);
                    }

                    @Override
                    @Nullable
                    public List<ConceptRow> forNorms(StringsBag norms) {
                        if (norms.uniqueTerms() == 0) {
                            return null;
                        }
                        return (List)normDictionary.get(norms);
                    }

                    @Override
                    public String source(int identifier) {
                        return (String)sources.get(identifier);
                    }
                };
                return conceptDictionary;
            }
            LOGGER.info("Done opening concepts dictionary.");
            RocksDbConceptDictionary rocksDbConceptDictionary = new RocksDbConceptDictionary(phrasesDB, lowercaseDB, normsDB, sources);
            return rocksDbConceptDictionary;
        }
        catch (IOException | RocksDBException e) {
            throw new BiomedicusException(e);
        }
    }

    private static <T> void dumpToMap(RocksDB db, Map<T, List<ConceptRow>> suiCuiTuis, Function<byte[], T> keyMapper) {
        try (RocksIterator rocksIterator = db.newIterator();){
            rocksIterator.seekToFirst();
            while (rocksIterator.isValid()) {
                byte[] keyBytes = rocksIterator.key();
                T key = keyMapper.apply(keyBytes);
                suiCuiTuis.put(key, RocksDbConceptDictionary.toList(rocksIterator.value()));
                rocksIterator.next();
            }
        }
        db.close();
    }
}

