/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.concepts;

import edu.umn.biomedicus.common.dictionary.StringsBag;
import edu.umn.biomedicus.concepts.ConceptDictionary;
import edu.umn.biomedicus.concepts.ConceptRow;
import edu.umn.biomedicus.framework.LifecycleManaged;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

class RocksDbConceptDictionary
implements ConceptDictionary,
LifecycleManaged {
    private final RocksDB phrases;
    private final RocksDB lowercase;
    private final RocksDB normsDB;
    private final Map<Integer, String> sources;

    RocksDbConceptDictionary(RocksDB phrases, RocksDB lowercase, RocksDB normsDB, Map<Integer, String> sources) {
        this.phrases = phrases;
        this.lowercase = lowercase;
        this.normsDB = normsDB;
        this.sources = sources;
    }

    static List<ConceptRow> toList(byte[] bytes) {
        ArrayList<ConceptRow> list = new ArrayList<ConceptRow>();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        while (buffer.hasRemaining()) {
            list.add(ConceptRow.next(buffer));
        }
        return list;
    }

    @Override
    @Nullable
    public List<ConceptRow> forPhrase(String phrase) {
        try {
            byte[] bytes = this.phrases.get(phrase.getBytes(StandardCharsets.UTF_8));
            return bytes == null ? null : RocksDbConceptDictionary.toList(bytes);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public List<ConceptRow> forLowercasePhrase(String phrase) {
        try {
            byte[] bytes = this.lowercase.get(phrase.getBytes(StandardCharsets.UTF_8));
            return bytes == null ? null : RocksDbConceptDictionary.toList(bytes);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public List<ConceptRow> forNorms(StringsBag norms) {
        if (norms.uniqueTerms() == 0) {
            return null;
        }
        try {
            byte[] bytes = this.normsDB.get(norms.getBytes());
            return bytes == null ? null : RocksDbConceptDictionary.toList(bytes);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public String source(int identifier) {
        return this.sources.get(identifier);
    }

    @Override
    public void doShutdown() {
    }
}

