/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.concepts;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SUI
implements Serializable {
    public static final Pattern SUI_PATTERN = Pattern.compile("S([\\d]{7})");
    private final int identifier;

    public SUI(int identifier) {
        this.identifier = identifier;
    }

    public SUI(String wordForm) {
        Matcher matcher = SUI_PATTERN.matcher(wordForm);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Word form does not match SUI pattern");
        }
        String identifier = matcher.group(1);
        this.identifier = Integer.parseInt(identifier);
    }

    public int identifier() {
        return this.identifier;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SUI sui = (SUI)o;
        return this.identifier == sui.identifier;
    }

    public int hashCode() {
        return this.identifier;
    }

    public String toString() {
        return String.format("S%07d", this.identifier);
    }
}

