/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.concepts;

import com.google.inject.ProvidedBy;
import edu.umn.biomedicus.concepts.SemanticTypeNetworkLoader;
import edu.umn.biomedicus.concepts.TN;
import edu.umn.biomedicus.concepts.TUI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@ProvidedBy(value=SemanticTypeNetworkLoader.class)
public class SemanticTypeNetwork {
    private static final Pattern PIPE = Pattern.compile("\\|");
    private final Map<TUI, TN> tuiToTN;
    private final Map<TUI, String> semanticTypeGroupMapping;

    public SemanticTypeNetwork(Map<TUI, TN> tuiToTN, Map<TUI, String> semanticTypeGroupMapping) {
        this.tuiToTN = tuiToTN;
        this.semanticTypeGroupMapping = semanticTypeGroupMapping;
    }

    public static SemanticTypeNetwork loadFromFiles(Path srdefPath, Path semgroupsPath) throws IOException {
        Map<TUI, TN> tuiToTN = Files.lines(srdefPath).map(PIPE::split).map(SrDefLine::new).collect(Collectors.toMap(SrDefLine::ui, SrDefLine::tn));
        Map<TUI, String> semanticTypeGroupMapping = Files.lines(semgroupsPath).map(PIPE::split).map(SemGroupLine::new).collect(Collectors.toMap(SemGroupLine::tui, SemGroupLine::group));
        return new SemanticTypeNetwork(tuiToTN, semanticTypeGroupMapping);
    }

    public boolean isa(TUI first, TUI second) {
        return this.tuiToTN.get(first).isA(this.tuiToTN.get(second));
    }

    public String getSemanticTypeGroup(TUI tui) {
        return this.semanticTypeGroupMapping.get(tui);
    }

    private static class SemGroupLine {
        private final String group;
        private final TUI tui;

        public SemGroupLine(String[] line) {
            this.group = line[0];
            this.tui = new TUI(line[2]);
        }

        public String group() {
            return this.group;
        }

        public TUI tui() {
            return this.tui;
        }
    }

    private static class SrDefLine {
        private final TUI ui;
        private final TN tn;

        public SrDefLine(String[] line) {
            this.ui = new TUI(line[1]);
            this.tn = new TN(line[3]);
        }

        public TUI ui() {
            return this.ui;
        }

        public TN tn() {
            return this.tn;
        }
    }
}

