/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.concepts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.concepts.SemanticTypeNetwork;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.DataLoader;
import java.io.IOException;
import java.nio.file.Path;

@Singleton
public class SemanticTypeNetworkLoader
extends DataLoader<SemanticTypeNetwork> {
    private final Path srdefPath;
    private final Path semgroupsPath;

    @Inject
    public SemanticTypeNetworkLoader(@Setting(value="semanticNetwork.srdef.asDataPath") Path srdefPath, @Setting(value="semanticNetwork.semgroups.asDataPath") Path semgroupsPath) {
        this.srdefPath = srdefPath;
        this.semgroupsPath = semgroupsPath;
    }

    @Override
    protected SemanticTypeNetwork loadModel() throws BiomedicusException {
        try {
            return SemanticTypeNetwork.loadFromFiles(this.srdefPath, this.semgroupsPath);
        }
        catch (IOException e) {
            throw new BiomedicusException(e);
        }
    }
}

