/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.concepts;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TN {
    public static final Pattern TN_PATTERN = Pattern.compile("([A-Z])(([1-9]\\.)*[1-9])?");
    private final char category;
    private final byte[] number;

    public TN(String tnString) {
        Matcher matcher = TN_PATTERN.matcher(tnString);
        if (matcher.find()) {
            this.category = matcher.group(1).charAt(0);
            String group = matcher.group(2);
            List bytes = group == null || group.isEmpty() ? Collections.emptyList() : Arrays.stream(group.split("\\.")).map(Byte::parseByte).collect(Collectors.toList());
            this.number = new byte[bytes.size()];
            for (int i = 0; i < this.number.length; ++i) {
                this.number[i] = (Byte)bytes.get(i);
            }
        } else {
            throw new IllegalArgumentException("String is not a semantic network RTN or STN: " + tnString);
        }
    }

    public boolean isA(TN other) {
        if (this.category != other.category) {
            return false;
        }
        if (other.number.length > this.number.length) {
            return false;
        }
        for (int i = 0; i < other.number.length; ++i) {
            if (this.number[i] == other.number[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TN tn = (TN)o;
        if (this.category != tn.category) {
            return false;
        }
        return Arrays.equals(this.number, tn.number);
    }

    public int hashCode() {
        int result = this.category;
        result = 31 * result + Arrays.hashCode(this.number);
        return result;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(".", "" + this.category, "");
        for (byte aNumber : this.number) {
            joiner.add(Byte.toString(aNumber));
        }
        return joiner.toString();
    }
}

