/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import edu.umn.biomedicus.annotations.Setting;
import edu.umn.biomedicus.framework.SettingImpl;
import java.lang.annotation.Annotation;
import java.nio.file.Path;

@Singleton
public final class Application {
    private final Injector injector;
    private final Path confFolder;
    private final Path dataFolder;

    @Inject
    Application(Injector injector, @Setting(value="paths.conf") Path confFolder, @Setting(value="paths.data") Path dataFolder) {
        this.injector = injector;
        this.confFolder = confFolder;
        this.dataFolder = dataFolder;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public <T> T getInstance(Class<T> tClass) {
        return (T)this.injector.getInstance(tClass);
    }

    public <T> T getGlobalSetting(Class<T> settingType, String key) {
        return (T)this.injector.getInstance(Key.get(settingType, (Annotation)new SettingImpl(key)));
    }

    public Path confFolder() {
        return this.confFolder;
    }

    public Path getConfFolder() {
        return this.confFolder;
    }

    public Path dataFolder() {
        return this.dataFolder;
    }

    public Path getDataFolder() {
        return this.dataFolder;
    }
}

