/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public final class BiomedicusScopes {
    private static final ThreadLocal<Context> PROCESSOR_CONTEXT = new ThreadLocal();
    public static final Scope PROCESSOR_SCOPE = new ContextScope(PROCESSOR_CONTEXT);

    private static Map<Key<?>, Object> checkForInvalidSeedsAndCopy(Map<Key<?>, Object> seededObjects) {
        for (Map.Entry<Key<?>, Object> entry : seededObjects.entrySet()) {
            Key<?> key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("Seeded objects contains null key. Key: " + key);
            }
            Class rawType = key.getTypeLiteral().getRawType();
            if (rawType.isInstance(value)) continue;
            if (!(value instanceof Key)) {
                throw new IllegalArgumentException("Seeded object is not instance of key type. Key: " + key + ". Value: " + value);
            }
            Class valueRawType = ((Key)value).getTypeLiteral().getRawType();
            if (rawType.isAssignableFrom(valueRawType)) continue;
            throw new IllegalArgumentException("Chained value key type does not extend the key type. Key Key: " + key + ". Value Key: " + value);
        }
        return seededObjects.entrySet().stream().collect(Collectors.toConcurrentMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Context createProcessorContext(Map<Key<?>, Object> seededObjects) {
        return new Context(PROCESSOR_CONTEXT, BiomedicusScopes.checkForInvalidSeedsAndCopy(seededObjects));
    }

    public static <T> Provider<T> providedViaSeeding() {
        return () -> {
            throw new IllegalStateException("This provider should not be called, the object should be seeded when entering a scope");
        };
    }

    private static class ContextScope
    implements Scope {
        private final ThreadLocal<Context> contextRef;

        private ContextScope(ThreadLocal<Context> contextRef) {
            this.contextRef = contextRef;
        }

        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            return () -> {
                Context context = this.contextRef.get();
                if (context != null) {
                    return context.get(key, unscoped);
                }
                throw new OutOfScopeException("Not currently in a scope");
            };
        }
    }

    public static final class Context {
        private final ThreadLocal<Context> contextRef;
        private final Map<Key<?>, Object> objectsMap;
        private final Object lock = new Object();

        private Context(ThreadLocal<Context> contextRef, Map<Key<?>, Object> objectsMap) {
            this.contextRef = contextRef;
            this.objectsMap = objectsMap;
        }

        public synchronized <T> T call(Callable<T> callable) throws Exception {
            if (this.contextRef.get() != null) {
                throw new IllegalStateException("Processor scope already in progress");
            }
            this.contextRef.set(this);
            try {
                T t = callable.call();
                return t;
            }
            finally {
                this.contextRef.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> T get(Key<T> key, Provider<T> unscoped) {
            Object t = this.objectsMap.get(key);
            if (t == null) {
                Object object = this.lock;
                synchronized (object) {
                    t = this.objectsMap.get(key);
                    if (t == null && !Scopes.isCircularProxy((Object)(t = unscoped.get()))) {
                        this.objectsMap.put(key, t);
                    }
                }
            }
            return (T)t;
        }
    }
}

