/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.Application;
import edu.umn.biomedicus.framework.BiomedicusModule;
import edu.umn.biomedicus.framework.SettingsBinder;
import edu.umn.biomedicus.framework.SettingsLoader;
import edu.umn.biomedicus.measures.BiomedicusMeasuresModule;
import edu.umn.biomedicus.vocabulary.VocabularyModule;
import edu.umn.nlpengine.Systems;
import edu.umn.nlpengine.SystemsModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public final class Bootstrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bootstrapper.class);
    private final List<Module> modules = new ArrayList<Module>();
    @Nullable
    private String home = null;
    @Nullable
    private Injector injector = null;
    @Nullable
    private Map<String, Object> overloadedSettings = null;

    public Bootstrapper() {
        this.modules.add((Module)new VocabularyModule());
        this.modules.add((Module)new BiomedicusMeasuresModule());
    }

    public static Application create(Injector injector) throws BiomedicusException {
        Bootstrapper bootstrapper = new Bootstrapper();
        bootstrapper.setInjector(injector);
        bootstrapper.initializePathsAndConfiguration();
        return bootstrapper.biomedicus();
    }

    public static Application create(Map<String, Object> overloadedSettings, Module ... additionalModules) throws BiomedicusException {
        Bootstrapper bootstrapper = new Bootstrapper();
        bootstrapper.setOverloadedSettings(overloadedSettings);
        for (Module additionalModule : additionalModules) {
            bootstrapper.addAdditionalModule(additionalModule);
        }
        bootstrapper.initializePathsAndConfiguration();
        return bootstrapper.biomedicus();
    }

    public static Application create(Module ... additionalModules) throws BiomedicusException {
        return Bootstrapper.create(Collections.emptyMap(), additionalModules);
    }

    private Bootstrapper setInjector(Injector injector) {
        this.injector = injector;
        return this;
    }

    private Bootstrapper setOverloadedSettings(Map<String, Object> settings) {
        this.overloadedSettings = settings;
        return this;
    }

    private void addAdditionalModule(Module module) {
        this.modules.add(module);
    }

    private void initializePathsAndConfiguration() throws BiomedicusException {
        String overloadFile;
        Path dataPath;
        String dataEnv;
        Map biomedicusConfiguration;
        String conf;
        this.home = System.getProperty("biomedicus.paths.home");
        if (this.home == null) {
            this.home = System.getenv("BIOMEDICUS_HOME");
        }
        if ((conf = System.getProperty("biomedicus.paths.conf")) == null) {
            conf = System.getenv("BIOMEDICUS_CONF");
        }
        Path configDir = conf != null ? this.absoluteOrResolveAgainstHome(Paths.get(conf, new String[0])) : this.homePath().resolve("config");
        LOGGER.info("Using configuration directory: {}", (Object)configDir);
        Yaml yaml = new Yaml();
        Path configurationFilePath = configDir.resolve("biomedicusConfiguration.yml");
        try (BufferedReader bufferedReader = Files.newBufferedReader(configurationFilePath);){
            biomedicusConfiguration = (Map)yaml.load((Reader)bufferedReader);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load configuration, falling back to default configuration file.");
            try (BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("biomedicusConfiguration.yml")));){
                biomedicusConfiguration = (Map)yaml.load((Reader)bufferedReader2);
            }
            catch (IOException e1) {
                throw new BiomedicusException(e1);
            }
        }
        Map biomedicusPaths = null;
        Object pathsObject = biomedicusConfiguration.get("paths");
        if (pathsObject instanceof Map) {
            biomedicusPaths = (Map)pathsObject;
        }
        if (this.home == null && biomedicusPaths != null) {
            Object home = biomedicusPaths.get("home");
            if (!(home instanceof String)) {
                throw new BiomedicusException("home path not String: " + home, new String[0]);
            }
            this.home = (String)home;
        }
        if ((dataEnv = System.getProperty("biomedicus.paths.data")) == null) {
            dataEnv = System.getenv("BIOMEDICUS_DATA");
        }
        if (dataEnv != null) {
            dataPath = Paths.get(dataEnv, new String[0]);
        } else if (biomedicusPaths != null && biomedicusPaths.containsKey("data")) {
            String dataDir = (String)biomedicusPaths.get("data");
            dataPath = this.absoluteOrResolveAgainstHome(Paths.get(dataDir, new String[0]));
        } else {
            dataPath = this.homePath().resolve("data");
        }
        LOGGER.info("Using data directory: {}", (Object)dataPath);
        SettingsBinder settingsBinder = SettingsBinder.create(dataPath, configDir, this.homePath());
        SettingsLoader configurationSettingsLoader = new SettingsLoader(biomedicusConfiguration);
        configurationSettingsLoader.loadSettings();
        configurationSettingsLoader.addToBinder(settingsBinder);
        Systems systems = new Systems();
        systems.addSystems(configurationSettingsLoader.getSystemClasses());
        try {
            if (Files.exists(configDir, new LinkOption[0])) {
                Iterator settingsFilesItr = Files.walk(configDir, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith("Settings.yml")).iterator();
                while (settingsFilesItr.hasNext()) {
                    Path settingsFilePath = (Path)settingsFilesItr.next();
                    SettingsLoader settingsLoader = SettingsLoader.createSettingsLoader(settingsFilePath);
                    settingsLoader.loadSettings();
                    settingsLoader.addToBinder(settingsBinder);
                    systems.addSystems(settingsLoader.getSystemClasses());
                }
            }
        }
        catch (IOException e) {
            throw new BiomedicusException(e);
        }
        if (this.overloadedSettings != null) {
            settingsBinder.addSettings(this.overloadedSettings);
        }
        if ((overloadFile = System.getProperty("biomedicus.settings.overloads")) != null) {
            SettingsLoader settingsLoader;
            LOGGER.info("Loading setting overloads: {}", (Object)overloadFile);
            try {
                Path overloadFilePath = Paths.get(overloadFile, new String[0]);
                settingsLoader = SettingsLoader.createSettingsLoader(this.absoluteOrResolveAgainstHome(overloadFilePath));
            }
            catch (IOException e) {
                throw new BiomedicusException(e);
            }
            settingsLoader.loadSettings();
            settingsLoader.addToBinder(settingsBinder);
            systems.addSystems(settingsLoader.getSystemClasses());
        }
        this.modules.add((Module)new SystemsModule(systems));
        this.modules.add((Module)new BiomedicusModule(this.homePath()));
        this.modules.add(settingsBinder.createModule());
    }

    private Path absoluteOrResolveAgainstHome(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return this.homePath().resolve(path);
    }

    private Path homePath() {
        if (this.home == null) {
            throw new IllegalStateException("BioMedICUS home directory is not configured. Use the the Java property -Dbiomedicus.paths.home=[home dir], or set it in the biomedicusConfiguration.yml file and set the -Dbiomedicus.paths.conf Java property to the directory containing biomedicusConfiguration.yml");
        }
        return Paths.get(this.home, new String[0]);
    }

    private Application biomedicus() {
        Injector biomedicusInjector = this.injector != null ? this.injector.createChildInjector(this.modules) : Guice.createInjector((Stage)Stage.PRODUCTION, this.modules);
        return (Application)biomedicusInjector.getInstance(Application.class);
    }
}

