/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import com.google.inject.Provider;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.EagerLoadable;
import javax.annotation.Nullable;

public abstract class DataLoader<T>
implements Provider<T>,
EagerLoadable {
    private final transient Object lock = new Object();
    private volatile transient boolean loaded = false;
    @Nullable
    private volatile transient T instance;

    @Override
    public void eagerLoad() throws BiomedicusException {
        if (!this.loaded) {
            this.load();
        }
    }

    public T get() {
        if (!this.loaded) {
            try {
                this.load();
            }
            catch (BiomedicusException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws BiomedicusException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.loaded) {
                this.instance = this.loadModel();
                if (this.instance == null) {
                    throw new IllegalStateException("Loader returned null");
                }
                this.loaded = true;
            }
        }
    }

    protected abstract T loadModel() throws BiomedicusException;
}

