/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import com.google.inject.Singleton;
import edu.umn.biomedicus.exc.BiomedicusException;
import edu.umn.biomedicus.framework.LifecycleManaged;
import java.util.ArrayList;
import java.util.Collection;

@Singleton
public class LifecycleManager {
    private final Collection<LifecycleManaged> lifecycleManageds = new ArrayList<LifecycleManaged>();

    void register(LifecycleManaged lifecycleManaged) {
        this.lifecycleManageds.add(lifecycleManaged);
    }

    public void triggerShutdown() throws BiomedicusException {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        for (LifecycleManaged lifecycleManaged : this.lifecycleManageds) {
            try {
                lifecycleManaged.doShutdown();
            }
            catch (Exception e) {
                exceptionList.add(e);
            }
        }
        if (!exceptionList.isEmpty()) {
            BiomedicusException e = new BiomedicusException("Multiple exceptions (" + exceptionList.size() + ") while shutting down lifecycle resources", new String[0]);
            exceptionList.forEach(e::addSuppressed);
            throw e;
        }
    }
}

