/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import edu.umn.biomedicus.framework.LabelAliases;
import edu.umn.biomedicus.framework.SearchResult;
import edu.umn.biomedicus.framework.Searcher;
import edu.umn.nlpengine.AbstractTextRange;
import edu.umn.nlpengine.Document;
import edu.umn.nlpengine.Label;
import edu.umn.nlpengine.LabelIndex;
import edu.umn.nlpengine.Span;
import edu.umn.nlpengine.TextRange;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchExpr {
    static final Node ACCEPT = new Node(){

        @Override
        @Nullable
        Class<? extends Label> firstType() {
            return null;
        }

        @Override
        void swapNext(Node next) {
            throw new IllegalStateException("Should never swap next on the accept node");
        }
    };
    static final Node FINAL_ACCEPT = new Node(){

        @Override
        State search(DefaultSearcher search, State state) {
            if (search.anchored && state.end != search.to) {
                return State.miss();
            }
            return state;
        }

        @Override
        @Nullable
        Class<? extends Label> firstType() {
            return null;
        }

        @Override
        void swapNext(Node next) {
            throw new IllegalStateException("Should never swap next on the final accept node");
        }
    };
    static final int LOOP_LIMIT = 10000;
    private static final Pattern NON_WHITESPACE = Pattern.compile("[\\p{all}&&[^\\p{Blank}]]");
    private final Node root;
    private final Node searchRoot;
    private final int numberGroups;
    private final int numberLocals;
    private final Map<String, Integer> groupNames;

    SearchExpr(Node root, Node searchRoot, int numberGroups, int numberLocals, Map<String, Integer> groupNames) {
        this.root = root;
        this.searchRoot = searchRoot;
        this.numberGroups = numberGroups;
        this.numberLocals = numberLocals;
        this.groupNames = groupNames;
    }

    public static SearchExpr parse(LabelAliases labelAliases, String expression) {
        return new Parser(labelAliases, expression).compile();
    }

    public Searcher createSearcher(Document document) {
        return new DefaultSearcher(document, (TextRange)document);
    }

    public Searcher createSearcher(Document document, TextRange span) {
        return new DefaultSearcher(document, span);
    }

    class DefaultSearcher
    extends AbstractTextRange
    implements Searcher,
    SearchResult {
        final Document document;
        final Label[] labels;
        final int[] groups;
        final int[] locals;
        boolean anchored;
        boolean found;
        int from;
        int to;
        State result = State.miss();

        DefaultSearcher(DefaultSearcher defaultSearcher) {
            this.document = null;
            this.labels = (Label[])defaultSearcher.labels.clone();
            this.groups = (int[])defaultSearcher.groups.clone();
            this.locals = null;
            this.found = defaultSearcher.found;
            this.result = defaultSearcher.result;
        }

        DefaultSearcher(Document document, TextRange span) {
            this.document = document;
            this.labels = new Label[SearchExpr.this.numberGroups];
            this.groups = new int[SearchExpr.this.numberGroups * 2];
            this.locals = new int[SearchExpr.this.numberLocals];
            this.from = span.getStartIndex();
            this.to = span.getEndIndex();
        }

        @Override
        @Nullable
        public Label getLabel(@Nonnull String name) {
            Integer integer = (Integer)SearchExpr.this.groupNames.get(name);
            if (integer == null || !this.result.validGroups.contains(integer)) {
                return null;
            }
            return this.labels[integer];
        }

        @Override
        @Nullable
        public Span getSpan(@Nonnull String name) {
            int end;
            Integer integer = (Integer)SearchExpr.this.groupNames.get(name);
            if (integer == null || !this.result.validGroups.contains(integer)) {
                return null;
            }
            int begin = this.groups[integer];
            if (begin > (end = this.groups[integer + 1]) || end < 0) {
                return null;
            }
            return new Span(begin, end);
        }

        @Override
        public boolean found() {
            return this.found;
        }

        @Override
        public boolean search() {
            this.anchored = false;
            Arrays.fill(this.groups, -1);
            Arrays.fill(this.labels, null);
            this.result = SearchExpr.this.searchRoot.search(this, new State(this.from, this.from, this.to, new ArrayList<Integer>()));
            this.from = this.result.end;
            this.found = this.result.isHit();
            return this.found;
        }

        @Override
        public boolean search(int begin, int end) {
            this.from = Math.max(this.from, begin);
            this.to = end;
            return this.search();
        }

        @Override
        public boolean search(Span span) {
            return this.search(span.getStartIndex(), span.getEndIndex());
        }

        @Override
        public boolean match() {
            this.anchored = true;
            Arrays.fill(this.groups, -1);
            Arrays.fill(this.labels, null);
            this.result = SearchExpr.this.root.search(this, new State(this.from, this.from, this.to, new ArrayList<Integer>()));
            this.found = this.result.isHit();
            return this.found;
        }

        @Override
        public boolean match(int begin, int end) {
            this.from = begin;
            this.to = end;
            return this.match();
        }

        @Override
        public boolean match(Span span) {
            return this.match(span.getStartIndex(), span.getEndIndex());
        }

        @Override
        public Optional<Span> getSpan() {
            if (this.result.isMiss()) {
                return Optional.empty();
            }
            return Optional.of(this.result.getCovered());
        }

        @Override
        public Collection<String> getGroupNames() {
            return SearchExpr.this.groupNames.keySet();
        }

        @Override
        public int getBegin() {
            return this.result.begin;
        }

        @Override
        public int getEnd() {
            return this.result.end;
        }

        @Override
        public SearchResult toSearchResult() {
            return this.found ? new DefaultSearcher(this) : null;
        }

        public int getStartIndex() {
            return this.result.begin;
        }

        public int getEndIndex() {
            return this.result.end;
        }
    }

    static class State {
        final int begin;
        final int end;
        final int limit;
        List<Integer> validGroups;

        State(int begin, int end, int limit, List<Integer> validGroups) {
            this.begin = begin;
            this.end = end;
            this.limit = limit;
            this.validGroups = validGroups;
        }

        static State miss() {
            State state = new State(-1, -1, -1, Collections.emptyList());
            state.validGroups = Collections.emptyList();
            return state;
        }

        State advance(int begin, int end) {
            return new State(begin, end, this.limit, this.validGroups);
        }

        State setBegin(int begin) {
            return new State(begin, this.end, this.limit, this.validGroups);
        }

        State setBegin(int begin, Class<?> firstType) {
            return new State(begin, this.end, this.limit, this.validGroups);
        }

        State pin() {
            return new State(this.begin, this.begin, this.end, this.validGroups);
        }

        boolean isMiss() {
            return this.begin == -1;
        }

        boolean isHit() {
            return this.begin != -1;
        }

        boolean isCovered(State other) {
            return this.begin == other.begin && this.end == other.end;
        }

        Span getUncovered() {
            return new Span(this.end, this.limit);
        }

        Span getCovered() {
            return new Span(this.begin, this.end);
        }

        public State copy() {
            return new State(this.begin, this.end, this.limit, this.validGroups);
        }

        void addValidGroup(int groupNo) {
            if (!this.validGroups.contains(groupNo)) {
                this.validGroups = new ArrayList<Integer>(this.validGroups);
                this.validGroups.add(groupNo);
            }
        }
    }

    static class TypeMatch
    extends Node {
        final Class<? extends Label> labelType;
        final List<PropertyMatch> requiredProperties = new ArrayList<PropertyMatch>();
        final boolean seek;
        final boolean anonymous;
        final int group;
        final boolean contains;

        TypeMatch(Class<? extends Label> labelType, boolean seek, boolean anonymous, boolean contains, int group) {
            this.labelType = labelType;
            this.seek = seek;
            this.anonymous = anonymous;
            this.group = group;
            this.contains = contains;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            LabelIndex labelIndex;
            LabelIndex labelIndex2 = labelIndex = this.contains ? search.document.labelIndex(this.labelType).containing((TextRange)state.getCovered()) : search.document.labelIndex(this.labelType).inside((TextRange)state.getUncovered());
            if (!this.seek) {
                State advance;
                State result;
                Label label = labelIndex.first();
                if (label == null) {
                    return State.miss();
                }
                if (!this.propertiesMatch(search, (TextRange)label)) {
                    return State.miss();
                }
                if (this.group != -1) {
                    search.groups[this.group] = label.getStartIndex();
                    search.groups[this.group + 1] = label.getEndIndex();
                    search.labels[this.group] = label;
                }
                if ((result = this.next.search(search, advance = this.anonymous ? state : state.advance(label.getStartIndex(), label.getEndIndex()))).isHit()) {
                    if (this.group != -1) {
                        result.addValidGroup(this.group);
                    }
                    if (this.anonymous) {
                        return result.setBegin(result.begin, this.labelType);
                    }
                    return result.setBegin(label.getStartIndex(), this.labelType);
                }
                return result;
            }
            for (Label label : labelIndex) {
                State advance;
                State result;
                if (!this.propertiesMatch(search, (TextRange)label)) continue;
                if (this.group != -1) {
                    search.groups[this.group] = label.getStartIndex();
                    search.groups[this.group + 1] = label.getEndIndex();
                    search.labels[this.group] = label;
                }
                if (!(result = this.next.search(search, advance = this.anonymous ? state : state.advance(label.getStartIndex(), label.getEndIndex()))).isHit()) continue;
                if (this.group != -1) {
                    result.addValidGroup(this.group);
                }
                if (this.anonymous) {
                    return result.setBegin(result.begin, this.labelType);
                }
                return result.setBegin(label.getStartIndex(), this.labelType);
            }
            return State.miss();
        }

        @Override
        @Nullable
        Class<? extends Label> firstType() {
            return this.labelType;
        }

        boolean propertiesMatch(DefaultSearcher search, TextRange label) {
            for (PropertyMatch requiredProperty : this.requiredProperties) {
                if (requiredProperty.doesMatch(search, label)) continue;
                return false;
            }
            return true;
        }

        void addPropertyMatch(String name, Object value) {
            this.requiredProperties.add(new ValuedPropertyMatch(name, value));
        }

        void addRegexMatch(String name, Pattern pattern) {
            this.requiredProperties.add(new RegexPropertyMatch(name, pattern));
        }

        void addCaseInsensitiveMatch(String name, String value) {
            this.requiredProperties.add(new CaseInsensitivePropertyMatch(name, value));
        }

        void addAlternationsPropertyMatch(AlternationsPropertyMatch alternationsPropertyMatch) {
            this.requiredProperties.add(alternationsPropertyMatch);
        }

        void addPropertyValueBackReference(String name, String group, Method backrefMethod) {
            this.requiredProperties.add(new PropertyValueBackReference(name, group, backrefMethod));
        }

        void addNumberPropertyMatch(String name, Object value) {
            this.requiredProperties.add(new NumberPropertyMatch(name, value));
        }

        void addSpanBackReference(String name, String group) {
            this.requiredProperties.add(new SpanBackReference(name, group));
        }

        public void addEnumMatch(String propertyName, String enumName) {
            this.requiredProperties.add(new EnumPropertyMatch(propertyName, enumName));
        }

        class EnumPropertyMatch
        extends PropertyMatch {
            private Enum value;

            EnumPropertyMatch(String name, String enumName) {
                super(name);
                Class<Enum> enumType = this.readMethod.getReturnType().asSubclass(Enum.class);
                Enum[] constants = enumType.getEnumConstants();
                this.value = null;
                for (Enum constant : constants) {
                    if (!constant.name().equals(enumName)) continue;
                    this.value = constant;
                }
                if (this.value == null) {
                    throw new IllegalArgumentException("Enum not found: " + enumName);
                }
            }

            @Override
            boolean doesMatch(DefaultSearcher search, TextRange label) {
                try {
                    Object invoke = this.readMethod.invoke((Object)label, new Object[0]);
                    return this.value.equals(invoke);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        class SpanBackReference
        extends PropertyMatch {
            private final String group;

            SpanBackReference(String name, String group) {
                super(name);
                this.group = group;
            }

            @Override
            boolean doesMatch(DefaultSearcher search, TextRange label) {
                Span span = search.getSpan(this.group);
                try {
                    return span != null && span.equals(this.readMethod.invoke((Object)label, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("");
                }
            }
        }

        class PropertyValueBackReference
        extends PropertyMatch {
            private final String group;
            private final Method backrefMethod;

            PropertyValueBackReference(String name, String group, Method backrefMethod) {
                super(name);
                this.group = group;
                this.backrefMethod = backrefMethod;
            }

            @Override
            boolean doesMatch(DefaultSearcher search, TextRange label) {
                Label groupLabel = search.getLabel(this.group);
                try {
                    return groupLabel != null && this.backrefMethod.invoke((Object)groupLabel, new Object[0]).equals(this.readMethod.invoke((Object)label, new Object[0]));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("");
                }
            }
        }

        class ValuedPropertyMatch
        extends PropertyMatch {
            final Object value;

            ValuedPropertyMatch(String name, Object value) {
                super(name);
                this.value = value;
            }

            @Override
            boolean doesMatch(DefaultSearcher search, TextRange label) {
                try {
                    Object invoke = this.readMethod.invoke((Object)label, new Object[0]);
                    return this.value.equals(invoke);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        class NumberPropertyMatch
        extends PropertyMatch {
            final Object value;

            NumberPropertyMatch(String name, Object value) {
                super(name);
                this.value = value;
            }

            @Override
            boolean doesMatch(DefaultSearcher search, TextRange label) {
                try {
                    double second;
                    Object invoke = this.readMethod.invoke((Object)label, new Object[0]);
                    if (invoke == null || !(invoke instanceof Number)) {
                        return false;
                    }
                    double first = ((Number)invoke).doubleValue();
                    return Math.abs(first - (second = ((Number)this.value).doubleValue())) < 1.0E-10;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("");
                }
            }
        }

        class AlternationsPropertyMatch
        extends PropertyMatch {
            final PropertyMatch[] propertyMatches;

            AlternationsPropertyMatch(String name, PropertyMatch[] propertyMatches) {
                super(name);
                this.propertyMatches = propertyMatches;
            }

            @Override
            boolean doesMatch(DefaultSearcher search, TextRange label) {
                for (PropertyMatch propertyMatch : this.propertyMatches) {
                    if (!propertyMatch.doesMatch(search, label)) continue;
                    return true;
                }
                return false;
            }
        }

        class CaseInsensitivePropertyMatch
        extends PropertyMatch {
            final String value;

            CaseInsensitivePropertyMatch(String name, String value) {
                super(name);
                this.value = value;
            }

            @Override
            boolean doesMatch(DefaultSearcher search, TextRange label) {
                try {
                    Object result = this.readMethod.invoke((Object)label, new Object[0]);
                    if (result == null || !(result instanceof CharSequence)) {
                        return false;
                    }
                    if (!(result instanceof String)) {
                        result = result.toString();
                    }
                    return this.value.equalsIgnoreCase((String)result);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        class RegexPropertyMatch
        extends PropertyMatch {
            final Pattern pattern;

            RegexPropertyMatch(String name, Pattern pattern) {
                super(name);
                this.pattern = pattern;
            }

            @Override
            boolean doesMatch(DefaultSearcher search, TextRange label) {
                try {
                    Object value = this.readMethod.invoke((Object)label, new Object[0]);
                    return value != null && value instanceof CharSequence && this.pattern.matcher((CharSequence)value).matches();
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException();
                }
            }
        }

        abstract class PropertyMatch {
            final String name;
            final Method readMethod;

            PropertyMatch(String name) {
                this.name = name;
                try {
                    this.readMethod = TypeMatch.this.labelType.getMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            }

            abstract boolean doesMatch(DefaultSearcher var1, TextRange var2);
        }
    }

    static class NoText
    extends Node {
        NoText() {
        }

        @Override
        State search(DefaultSearcher search, State state) {
            State result = this.next.search(search, state);
            if (result.isMiss()) {
                return result;
            }
            if (NON_WHITESPACE.matcher(search.document.getText().subSequence(state.end, result.begin)).find()) {
                return State.miss();
            }
            return result;
        }
    }

    static class InnerConditions
    extends Node {
        final int localAddr;
        private final boolean covered;
        Node[] conditions = new Node[2];
        int size = 0;

        InnerConditions(int localAddr, boolean covered) {
            this.localAddr = localAddr;
            this.covered = covered;
        }

        @Override
        public State search(DefaultSearcher search, State state) {
            State pin = state.pin();
            for (int i = 0; i < this.size; ++i) {
                State result = this.conditions[i].search(search, pin);
                if (!result.isMiss() && (!this.covered || state.isCovered(result))) continue;
                return State.miss();
            }
            return this.next.search(search, state);
        }

        void addCondition(Node node) {
            if (this.conditions.length == this.size) {
                Node[] tmp = new Node[this.conditions.length * 2];
                System.arraycopy(this.conditions, 0, tmp, 0, this.size);
                this.conditions = tmp;
            }
            this.conditions[this.size++] = node;
        }
    }

    static class LoopHead
    extends Node {
        private final RecursiveLoop recursiveLoop;
        private final int beginLocal;

        LoopHead(RecursiveLoop recursiveLoop, int beginLocal) {
            this.recursiveLoop = recursiveLoop;
            this.beginLocal = beginLocal;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            search.locals[this.beginLocal] = state.end;
            return this.recursiveLoop.enterLoop(search, state);
        }

        @Override
        @Nullable
        Class<? extends Label> firstType() {
            return this.recursiveLoop.firstType();
        }
    }

    static class PossessiveLoop
    extends RecursiveLoop {
        PossessiveLoop(Node body, int countLocal, int beginLocal, int min, int max) {
            super(body, countLocal, beginLocal, min, max);
        }

        @Override
        State enterLoop(DefaultSearcher search, State state) {
            State result;
            int save = search.locals[this.countLocal];
            if (0 < this.min) {
                search.locals[this.countLocal] = 1;
                State result2 = this.body.search(search, state);
                State nextResult = this.next.search(search, result2);
                if (nextResult.isMiss()) {
                    return nextResult;
                }
                return nextResult.setBegin(result2.begin);
            }
            if (0 < this.max) {
                search.locals[this.countLocal] = 1;
                result = this.body.search(search, state);
                State nextResult = this.next.search(search, state);
                result = result.isMiss() || nextResult.begin < result.begin ? nextResult : (!(nextResult = this.next.search(search, result)).isMiss() ? nextResult.setBegin(result.begin) : nextResult);
            } else {
                search.locals[this.countLocal] = 1;
                result = this.body.search(search, state);
                State nextResult = this.next.search(search, state);
                if (result.isMiss() || nextResult.begin < result.begin) {
                    result = nextResult;
                }
            }
            search.locals[this.countLocal] = save;
            return result;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            if (state.end == search.locals[this.beginLocal]) {
                return this.next.search(search, state);
            }
            int count = search.locals[this.countLocal];
            if (count < this.min) {
                search.locals[this.countLocal] = count + 1;
                State result = this.body.search(search, state);
                if (result.isMiss()) {
                    search.locals[this.countLocal] = count;
                }
                return result;
            }
            if (count < this.max) {
                search.locals[this.countLocal] = count + 1;
                State result = this.body.search(search, state);
                if (result.isMiss()) {
                    search.locals[this.countLocal] = count;
                    return state;
                }
                return result;
            }
            search.locals[this.countLocal] = count + 1;
            State result = this.body.search(search, state);
            if (result.isHit()) {
                return State.miss();
            }
            search.locals[this.countLocal] = count;
            return state;
        }
    }

    static class LazyLoop
    extends RecursiveLoop {
        LazyLoop(Node body, int countLocal, int beginLocal, int min, int max) {
            super(body, countLocal, beginLocal, min, max);
        }

        @Override
        State enterLoop(DefaultSearcher search, State state) {
            State result;
            int save = search.locals[this.countLocal];
            if (0 < this.min) {
                search.locals[this.countLocal] = 1;
                result = this.body.search(search, state);
            } else {
                result = this.next.search(search, state);
                if (result.isMiss() && 0 < this.max) {
                    search.locals[this.countLocal] = 1;
                    result = this.body.search(search, state);
                }
            }
            search.locals[this.countLocal] = save;
            return result;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            if (state.end == search.locals[this.beginLocal]) {
                return this.next.search(search, state);
            }
            int count = search.locals[this.countLocal];
            if (count < this.min) {
                search.locals[this.countLocal] = count + 1;
                State result = this.body.search(search, state);
                if (result.isMiss()) {
                    search.locals[this.countLocal] = count;
                }
                return result;
            }
            State result = this.next.search(search, state);
            if (result.isHit()) {
                return result;
            }
            if (count < this.max) {
                search.locals[this.countLocal] = count + 1;
                result = this.body.search(search, state);
                if (result.isMiss()) {
                    search.locals[this.countLocal] = count;
                }
                return result;
            }
            return State.miss();
        }
    }

    static class GreedyLoop
    extends RecursiveLoop {
        GreedyLoop(Node body, int countLocal, int beginLocal, int min, int max) {
            super(body, countLocal, beginLocal, min, max);
        }

        @Override
        State enterLoop(DefaultSearcher search, State state) {
            State result;
            int save = search.locals[this.countLocal];
            if (0 < this.min) {
                search.locals[this.countLocal] = 1;
                result = this.body.search(search, state);
            } else if (0 < this.max) {
                search.locals[this.countLocal] = 1;
                result = this.body.search(search, state);
                State nextResult = this.next.search(search, state);
                if (result.isMiss() || nextResult.begin < result.begin) {
                    result = nextResult;
                }
            } else {
                result = this.next.search(search, state);
            }
            search.locals[this.countLocal] = save;
            return result;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            if (state.end == search.locals[this.beginLocal]) {
                return this.next.search(search, state);
            }
            int count = search.locals[this.countLocal];
            if (count < this.min) {
                search.locals[this.countLocal] = count + 1;
                State result = this.body.search(search, state);
                if (result.isMiss()) {
                    search.locals[this.countLocal] = count;
                }
                return result;
            }
            if (count < this.max) {
                search.locals[this.countLocal] = count + 1;
                State result = this.body.search(search, state);
                if (result.isMiss()) {
                    search.locals[this.countLocal] = count;
                } else {
                    return result;
                }
            }
            return this.next.search(search, state);
        }
    }

    static abstract class RecursiveLoop
    extends Node {
        final Node body;
        final int countLocal;
        final int beginLocal;
        final int min;
        final int max;

        RecursiveLoop(Node body, int countLocal, int beginLocal, int min, int max) {
            this.body = body;
            this.countLocal = countLocal;
            this.beginLocal = beginLocal;
            this.min = min;
            this.max = max;
        }

        abstract State enterLoop(DefaultSearcher var1, State var2);

        @Override
        @Nullable
        Class<? extends Label> firstType() {
            return this.body.firstType();
        }
    }

    static class PossessiveOptional
    extends Node {
        final Node node;

        PossessiveOptional(Node node) {
            this.node = node;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            State noOptionRes = this.next.search(search, state);
            State optionRes = this.node.search(search, state);
            if (optionRes.isHit()) {
                if (noOptionRes.isHit() && noOptionRes.begin < optionRes.begin) {
                    return noOptionRes;
                }
                State nextRes = this.next.search(search, optionRes);
                if (nextRes.isHit()) {
                    return nextRes.setBegin(optionRes.begin);
                }
                return nextRes;
            }
            return noOptionRes;
        }
    }

    static class LazyOptional
    extends Node {
        final Node node;

        LazyOptional(Node node) {
            this.node = node;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            State res = this.next.search(search, state);
            if (res.isHit()) {
                return res;
            }
            res = this.node.search(search, state);
            if (res.isMiss()) {
                return res;
            }
            return this.next.search(search, res);
        }
    }

    static class GreedyOptional
    extends Node {
        final Node option;

        GreedyOptional(Node option) {
            this.option = option;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            State nextRes;
            if (state.begin == state.end) {
                State noOptionRes = this.next.search(search, state);
                State optionRes = this.option.search(search, state);
                if (optionRes.isHit()) {
                    if (noOptionRes.isHit() && noOptionRes.begin < optionRes.begin) {
                        return noOptionRes;
                    }
                    State nextRes2 = this.next.search(search, optionRes);
                    if (nextRes2.isHit()) {
                        return nextRes2.setBegin(optionRes.begin);
                    }
                }
                return noOptionRes;
            }
            State result = this.option.search(search, state);
            if (result.isHit() && (nextRes = this.next.search(search, result)).isHit()) {
                return nextRes.setBegin(result.begin);
            }
            return this.next.search(search, state);
        }
    }

    static class Independent
    extends Node {
        final Node node;

        Independent(Node node) {
            this.node = node;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            State res = this.node.search(search, state);
            if (res.isHit()) {
                return this.next.search(search, res);
            }
            return res;
        }
    }

    static class NegativeLookahead
    extends Node {
        Node condition;

        NegativeLookahead(Node condition) {
            this.condition = condition;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            State res = this.condition.search(search, state.copy());
            if (res.isMiss()) {
                return this.next.search(search, state);
            }
            return State.miss();
        }
    }

    static class PositiveLookahead
    extends Node {
        Node condition;

        PositiveLookahead(Node condition) {
            this.condition = condition;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            State res = this.condition.search(search, state.copy());
            if (res.isMiss()) {
                return res;
            }
            return this.next.search(search, state);
        }
    }

    static class Noop
    extends Node {
        Noop() {
        }

        @Override
        public State search(DefaultSearcher search, State state) {
            return this.next.search(search, state);
        }
    }

    static class Branch
    extends Node {
        Node[] paths = new Node[2];
        int size = 0;

        Branch() {
        }

        void add(Node node) {
            if (this.size >= this.paths.length) {
                Node[] tmp = new Node[this.paths.length * 2];
                System.arraycopy(this.paths, 0, tmp, 0, this.paths.length);
                this.paths = tmp;
            }
            this.paths[this.size++] = node;
        }

        @Override
        public State search(DefaultSearcher search, State state) {
            ArrayList<State> hits = null;
            for (int i = 0; i < this.size; ++i) {
                State res = this.paths[i].search(search, state);
                if (!res.isHit()) continue;
                if (hits == null) {
                    hits = new ArrayList<State>();
                }
                hits.add(res);
            }
            if (hits == null) {
                return State.miss();
            }
            State first = (State)hits.get(0);
            for (int i = 1; i < hits.size(); ++i) {
                State other = (State)hits.get(i);
                if (other.begin >= first.begin || other.begin < state.end) continue;
                first = other;
            }
            return first;
        }
    }

    static class GroupTail
    extends Node {
        final int groupIndex;

        GroupTail(int groupIndex) {
            this.groupIndex = groupIndex;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            search.groups[this.groupIndex] = state.begin;
            search.groups[this.groupIndex + 1] = state.end;
            State result = this.next.search(search, state);
            result.addValidGroup(this.groupIndex);
            return result;
        }
    }

    static class LoadBegin
    extends Node {
        final int local;

        LoadBegin(int local) {
            this.local = local;
        }

        @Override
        public State search(DefaultSearcher search, State state) {
            return this.next.search(search, state.setBegin(search.locals[this.local]));
        }
    }

    static class SaveBegin
    extends Node {
        final int local;

        SaveBegin(int local) {
            this.local = local;
        }

        @Override
        State search(DefaultSearcher search, State state) {
            search.locals[this.local] = state.begin;
            return this.next.search(search, state);
        }
    }

    static class CharacterStepping
    extends Node {
        CharacterStepping() {
        }

        @Override
        State search(DefaultSearcher search, State state) {
            for (int i = state.end; i < state.limit; ++i) {
                State res = this.next.search(search, new State(i, i, state.limit, new ArrayList<Integer>()));
                if (!res.isHit()) continue;
                return res;
            }
            return State.miss();
        }
    }

    static class Node {
        protected Node next = ACCEPT;

        Node() {
        }

        State search(DefaultSearcher search, State state) {
            return state;
        }

        @Nullable
        Class<? extends Label> firstType() {
            return this.next.firstType();
        }

        void swapNext(Node next) {
            this.next = next;
        }
    }

    private static class Parser {
        private final LabelAliases labelAliases;
        private final String expression;
        private final char[] arr;
        private final Map<String, Integer> groupNames = new HashMap<String, Integer>();
        private final Map<Integer, Class<?>> groupTypes = new HashMap();
        private int index = 0;
        private int groupIndex = 0;
        private int localsCount = 0;

        private Parser(LabelAliases labelAliases, String expression) {
            this.labelAliases = labelAliases;
            this.expression = expression;
            char[] charr = expression.toCharArray();
            char[] tmp = new char[charr.length + 2];
            tmp[tmp.length - 1] = '\u0000';
            tmp[tmp.length - 2] = '\u0000';
            System.arraycopy(charr, 0, tmp, 0, charr.length);
            this.arr = tmp;
        }

        private SearchExpr compile() {
            LoadBegin end = new LoadBegin(this.localsCount++);
            end.next = FINAL_ACCEPT;
            Node root = this.alts(end);
            return new SearchExpr(root, root, this.groupIndex, this.localsCount, this.groupNames);
        }

        private Node alts(Node end) {
            Chain concat = this.concat(end);
            this.peekPastWhiteSpace();
            if (!this.accept(124)) {
                return concat.head;
            }
            Noop join = new Noop();
            join.swapNext(end);
            Branch branch = new Branch();
            if (concat.head == end) {
                branch.add(join);
            } else {
                branch.add(concat.head);
                concat.tail.swapNext(join);
            }
            do {
                Chain next = this.concat(join);
                branch.add(next.head);
                this.peekPastWhiteSpace();
            } while (this.accept(124));
            return branch;
        }

        private Chain concat(Node end) {
            Node head = null;
            Node tail = null;
            block5: while (true) {
                int ch = this.peekPastWhiteSpace();
                switch (ch) {
                    case 40: 
                    case 91: {
                        Chain chain = ch == 40 ? this.group() : this.pinning();
                        Chain repetition = this.groupRepetition(chain.head, chain.tail);
                        if (head == null) {
                            head = repetition.head;
                            tail = repetition.tail;
                            continue block5;
                        }
                        tail.next = repetition.head;
                        tail = repetition.tail;
                        continue block5;
                    }
                    case 45: {
                        this.read();
                        this.expect(62, "Missing > for ->");
                        NoText noText = new NoText();
                        if (tail == null) {
                            head = noText;
                            tail = noText;
                            continue block5;
                        }
                        tail = tail.next = noText;
                        continue block5;
                    }
                    case 0: 
                    case 38: 
                    case 41: 
                    case 93: 
                    case 124: {
                        break block5;
                    }
                    default: {
                        Node node = this.type(false, false);
                        Chain rep = this.atomicRepetition(node);
                        if (head == null) {
                            head = rep.head;
                            tail = rep.tail;
                            continue block5;
                        }
                        tail.swapNext(rep.head);
                        tail = rep.tail;
                        continue block5;
                    }
                }
                break;
            }
            if (head == null) {
                return new Chain(end, end);
            }
            if (head != tail) {
                Node tmp = head.next;
                int local = this.localsCount++;
                head.swapNext(new SaveBegin(local));
                head.next.swapNext(tmp);
                LoadBegin loadBegin = new LoadBegin(local);
                tail.swapNext(loadBegin);
                tail = loadBegin;
            }
            tail.swapNext(end);
            return new Chain(head, tail);
        }

        private Chain groupRepetition(Node head, Node tail) {
            int ch = this.peek();
            switch (ch) {
                case 63: {
                    ch = this.next();
                    if (ch == 43) {
                        this.next();
                        head = new PossessiveOptional(head);
                        return new Chain(head, head);
                    }
                    tail.swapNext(new Noop());
                    tail = tail.next;
                    Branch branch = new Branch();
                    if (ch == 63) {
                        this.next();
                        branch.add(tail);
                        branch.add(head);
                    } else {
                        branch.add(head);
                        branch.add(tail);
                    }
                    head = branch;
                    return new Chain(head, tail);
                }
                case 42: {
                    RecursiveLoop recursiveLoop;
                    ch = this.next();
                    if (ch == 43) {
                        this.next();
                        recursiveLoop = new PossessiveLoop(head, this.localsCount++, this.localsCount++, 0, 10000);
                    } else if (ch == 63) {
                        this.next();
                        recursiveLoop = new LazyLoop(head, this.localsCount++, this.localsCount++, 0, 10000);
                    } else {
                        recursiveLoop = new GreedyLoop(head, this.localsCount++, this.localsCount++, 0, 10000);
                    }
                    tail.next = recursiveLoop;
                    return new Chain(new LoopHead(recursiveLoop, recursiveLoop.beginLocal), recursiveLoop);
                }
                case 43: {
                    RecursiveLoop recursiveLoop;
                    ch = this.next();
                    if (ch == 43) {
                        this.next();
                        recursiveLoop = new PossessiveLoop(head, this.localsCount++, this.localsCount++, 1, 10000);
                    } else if (ch == 63) {
                        this.next();
                        recursiveLoop = new LazyLoop(head, this.localsCount++, this.localsCount++, 1, 10000);
                    } else {
                        recursiveLoop = new GreedyLoop(head, this.localsCount++, this.localsCount++, 1, 10000);
                    }
                    tail.next = recursiveLoop;
                    return new Chain(new LoopHead(recursiveLoop, recursiveLoop.beginLocal), recursiveLoop);
                }
                case 123: {
                    RecursiveLoop recursiveLoop;
                    Span span = this.parseCurlyRange();
                    int min = span.getStartIndex();
                    int max = span.getEndIndex();
                    ch = this.peek();
                    if (ch == 43) {
                        this.next();
                        recursiveLoop = new PossessiveLoop(head, this.localsCount++, this.localsCount++, min, max);
                    } else if (ch == 63) {
                        this.next();
                        recursiveLoop = new LazyLoop(head, this.localsCount++, this.localsCount++, min, max);
                    } else {
                        recursiveLoop = new GreedyLoop(head, this.localsCount++, this.localsCount++, min, max);
                    }
                    tail.next = recursiveLoop;
                    return new Chain(new LoopHead(recursiveLoop, recursiveLoop.beginLocal), recursiveLoop);
                }
            }
            return new Chain(head, tail);
        }

        private Chain atomicRepetition(Node node) {
            int ch = this.peek();
            RecursiveLoop loop = null;
            switch (ch) {
                case 63: {
                    ch = this.next();
                    if (ch == 63) {
                        this.next();
                        node = new LazyOptional(node);
                        break;
                    }
                    if (ch == 43) {
                        this.next();
                        node = new PossessiveOptional(node);
                        break;
                    }
                    node = new GreedyOptional(node);
                    break;
                }
                case 42: {
                    ch = this.next();
                    if (ch == 43) {
                        this.next();
                        loop = new PossessiveLoop(node, this.localsCount++, this.localsCount++, 0, 10000);
                        break;
                    }
                    if (ch == 63) {
                        this.next();
                        loop = new LazyLoop(node, this.localsCount++, this.localsCount++, 0, 10000);
                        break;
                    }
                    loop = new GreedyLoop(node, this.localsCount++, this.localsCount++, 0, 10000);
                    break;
                }
                case 43: {
                    ch = this.next();
                    if (ch == 43) {
                        this.next();
                        loop = new PossessiveLoop(node, this.localsCount++, this.localsCount++, 1, 10000);
                        break;
                    }
                    if (ch == 63) {
                        this.next();
                        loop = new LazyLoop(node, this.localsCount++, this.localsCount++, 1, 10000);
                        break;
                    }
                    loop = new GreedyLoop(node, this.localsCount++, this.localsCount++, 1, 10000);
                    break;
                }
                case 123: {
                    Span span = this.parseCurlyRange();
                    int min = span.getStartIndex();
                    int max = span.getEndIndex();
                    ch = this.peek();
                    if (ch == 43) {
                        this.next();
                        loop = new PossessiveLoop(node, this.localsCount++, this.localsCount++, min, max);
                        break;
                    }
                    if (ch == 63) {
                        this.next();
                        loop = new LazyLoop(node, this.localsCount++, this.localsCount++, min, max);
                        break;
                    }
                    loop = new GreedyLoop(node, this.localsCount++, this.localsCount++, min, max);
                }
            }
            if (loop != null) {
                node.next = loop;
                return new Chain(new LoopHead(loop, loop.beginLocal), loop);
            }
            return new Chain(node, node);
        }

        private Span parseCurlyRange() {
            int ch = this.peekNext();
            if (!Character.isDigit(ch)) {
                throw this.error("Curly brackets should be in format {min[,max]}");
            }
            this.skip();
            int min = 0;
            do {
                min = min * 10 + (ch - 48);
            } while ((ch = this.read()) <= 57 && ch >= 48);
            int max = min;
            if (ch == 44) {
                ch = this.read();
                max = 10000;
                if (ch != 125) {
                    max = 0;
                    while (ch <= 57 && ch >= 48) {
                        max = max * 10 + (ch - 48);
                        ch = this.read();
                    }
                }
            }
            if (ch != 125) {
                throw this.error("Unclosed curly bracket repetition");
            }
            if (max < min || min < 0 || max < 0) {
                throw this.error("Curly bracket repetition illegal range");
            }
            return new Span(min, max);
        }

        private Chain group() {
            Node head;
            Node tail;
            int ch = this.next();
            if (ch == 63) {
                ch = this.skip();
                switch (ch) {
                    case 33: 
                    case 61: {
                        tail = this.createGroupTail(null);
                        head = this.alts(tail);
                        if (ch == 61) {
                            tail = new PositiveLookahead(head);
                            head = tail;
                            break;
                        }
                        tail = new NegativeLookahead(head);
                        head = tail;
                        break;
                    }
                    case 62: {
                        tail = this.createGroupTail(null);
                        head = this.alts(tail);
                        tail = new Independent(head);
                        head = tail;
                        break;
                    }
                    case 60: {
                        GroupTail groupTail;
                        String name = this.readGroupName();
                        tail = groupTail = this.createGroupTail(this.groupNames.get(name));
                        this.groupNames.putIfAbsent(name, groupTail.groupIndex);
                        head = this.alts(tail);
                        break;
                    }
                    default: {
                        this.unread();
                        tail = this.createGroupTail(null);
                        head = this.alts(tail);
                        break;
                    }
                }
            } else {
                tail = this.createGroupTail(null);
                head = this.alts(tail);
            }
            this.peekPastWhiteSpace();
            this.expect(41, "Unclosed group");
            return new Chain(head, tail);
        }

        @Nonnull
        private GroupTail createGroupTail(@Nullable Integer existingIndex) {
            int group;
            if (existingIndex == null) {
                group = this.groupIndex;
                this.groupIndex += 2;
            } else {
                group = existingIndex;
            }
            return new GroupTail(group);
        }

        private String readGroupName() {
            int ch;
            StringBuilder stringBuilder = new StringBuilder();
            while ((ch = this.read()) != 62) {
                if (!Character.isAlphabetic(ch) && !Character.isDigit(ch)) {
                    throw this.error("Non alphanumeric character in capturing group name");
                }
                stringBuilder.append((char)ch);
            }
            if (stringBuilder.length() == 0) {
                throw this.error("0-length named capturing gorup");
            }
            return stringBuilder.toString();
        }

        private Chain pinning() {
            this.next();
            int ch = this.peekPastWhiteSpace();
            boolean seek = false;
            boolean covered = false;
            boolean contains = false;
            if (ch == 94) {
                contains = true;
                seek = true;
                this.read();
            } else if (ch == 63) {
                seek = true;
                this.read();
            }
            if (ch == 33) {
                covered = true;
                this.read();
            }
            Node pinned = this.type(seek, contains);
            if (this.accept(93)) {
                return new Chain(pinned);
            }
            InnerConditions innerConditions = new InnerConditions(this.localsCount++, covered);
            do {
                Node inner = this.alts(ACCEPT);
                innerConditions.addCondition(inner);
                this.peekPastWhiteSpace();
            } while (this.accept(38));
            this.expect(93, "Unclosed pinning group");
            pinned.swapNext(innerConditions);
            return new Chain(pinned, innerConditions);
        }

        private Node type(boolean seek, boolean contains) {
            String type;
            int ch = this.read();
            if (!Character.isAlphabetic(ch) && !Character.isDigit(ch)) {
                throw this.error("Illegal identifier");
            }
            String first = this.readAlphanumeric(ch);
            String variable = null;
            ch = this.peek();
            if (ch == 58) {
                this.next();
                ch = this.read();
                variable = first;
                type = this.readAlphanumeric(ch);
            } else {
                type = first;
            }
            Class<? extends Label> aClass = this.labelAliases.getLabelable(type);
            if (aClass == null) {
                try {
                    aClass = Class.forName(type).asSubclass(Label.class);
                }
                catch (ClassNotFoundException e) {
                    throw this.error("Couldn't find a type with alias or name " + type);
                }
            }
            int group = -1;
            if (variable != null) {
                Integer existing = this.groupNames.get(variable);
                if (existing != null) {
                    group = existing;
                } else {
                    group = this.groupIndex;
                    this.groupTypes.put(group, aClass);
                    this.groupNames.put(variable, this.groupIndex);
                    this.groupIndex += 2;
                }
            }
            ch = this.peek();
            TypeMatch node = new TypeMatch(aClass, seek, contains, contains, group);
            if (ch == 60) {
                this.next();
                do {
                    this.parseProperty(node);
                } while (this.consumePastWhiteSpace(44));
                this.peekPastWhiteSpace();
                this.expect(62, "Unclosed properties group");
            }
            return node;
        }

        String readAlphanumeric(int ch) {
            StringBuilder groupName = new StringBuilder();
            groupName.append((char)ch);
            while (Character.isAlphabetic(ch = this.peek()) || Character.isDigit(ch)) {
                groupName.append((char)ch);
                this.read();
            }
            return groupName.toString();
        }

        String parseTypeName(int ch) {
            StringBuilder typeName = new StringBuilder();
            typeName.append((char)ch);
            this.read();
            while (Character.isAlphabetic(ch = this.peek()) || Character.isDigit(ch)) {
                typeName.append((char)ch);
            }
            return typeName.toString();
        }

        String parsePropertyStringValue() {
            int ch;
            StringBuilder vb = new StringBuilder();
            boolean escaped = false;
            while ((ch = this.read()) != 34 || escaped) {
                if (escaped) {
                    escaped = false;
                    vb.append((char)ch);
                    continue;
                }
                if (ch == 92) {
                    escaped = true;
                    continue;
                }
                vb.append((char)ch);
            }
            return vb.toString();
        }

        Object parseNumber(int ch) {
            StringBuilder nb = new StringBuilder();
            nb.append((char)ch);
            boolean isDouble = false;
            while (Character.isDigit(ch = this.peek()) || !isDouble && ch == 46) {
                if (ch == 46) {
                    isDouble = true;
                }
                nb.append((char)ch);
                this.read();
            }
            String digitString = nb.toString();
            if (isDouble) {
                return Double.parseDouble(digitString);
            }
            return Long.parseLong(digitString);
        }

        String parseBackreferenceGroupName() {
            int ch;
            StringBuilder bsb = new StringBuilder();
            this.read();
            while (Character.isAlphabetic(ch = this.peek()) || Character.isDigit(ch)) {
                bsb.append(ch);
                this.read();
            }
            return bsb.toString();
        }

        void parseProperty(TypeMatch typeMatch) {
            int ch;
            StringBuilder pnsb = new StringBuilder();
            while (Character.isAlphabetic(ch = this.read()) || Character.isDigit(ch)) {
                pnsb.append((char)ch);
            }
            if (ch != 61) {
                throw this.error("Invalid property value format");
            }
            String propertyName = pnsb.toString();
            ch = this.read();
            if (ch == 34 || ch == 114 || ch == 105) {
                ArrayList<TypeMatch.PropertyMatch> propertyMatches = null;
                String value = null;
                Pattern pattern = null;
                String caseInsensitiveValue = null;
                if (ch == 114) {
                    this.read();
                    pattern = Pattern.compile(this.parsePropertyStringValue());
                } else if (ch == 105) {
                    this.read();
                    caseInsensitiveValue = this.parsePropertyStringValue();
                } else {
                    value = this.parsePropertyStringValue();
                }
                while (this.peek() == 124) {
                    this.read();
                    if (propertyMatches == null) {
                        propertyMatches = new ArrayList<TypeMatch.PropertyMatch>();
                        if (value != null) {
                            TypeMatch typeMatch2 = typeMatch;
                            typeMatch2.getClass();
                            propertyMatches.add(typeMatch2.new TypeMatch.ValuedPropertyMatch(propertyName, value));
                        } else if (caseInsensitiveValue != null) {
                            TypeMatch typeMatch3 = typeMatch;
                            typeMatch3.getClass();
                            propertyMatches.add(typeMatch3.new TypeMatch.CaseInsensitivePropertyMatch(propertyName, caseInsensitiveValue));
                        } else {
                            TypeMatch typeMatch4 = typeMatch;
                            typeMatch4.getClass();
                            propertyMatches.add(typeMatch4.new TypeMatch.RegexPropertyMatch(propertyName, pattern));
                        }
                    }
                    if ((ch = this.read()) == 114) {
                        this.read();
                        pattern = Pattern.compile(this.parsePropertyStringValue());
                        TypeMatch typeMatch5 = typeMatch;
                        typeMatch5.getClass();
                        propertyMatches.add(typeMatch5.new TypeMatch.RegexPropertyMatch(propertyName, pattern));
                        continue;
                    }
                    if (ch == 105) {
                        this.read();
                        caseInsensitiveValue = this.parsePropertyStringValue();
                        TypeMatch typeMatch6 = typeMatch;
                        typeMatch6.getClass();
                        propertyMatches.add(typeMatch6.new TypeMatch.CaseInsensitivePropertyMatch(propertyName, caseInsensitiveValue));
                        continue;
                    }
                    value = this.parsePropertyStringValue();
                    TypeMatch typeMatch7 = typeMatch;
                    typeMatch7.getClass();
                    propertyMatches.add(typeMatch7.new TypeMatch.ValuedPropertyMatch(propertyName, value));
                }
                if (propertyMatches != null) {
                    TypeMatch typeMatch8 = typeMatch;
                    typeMatch8.getClass();
                    typeMatch.addAlternationsPropertyMatch(typeMatch8.new TypeMatch.AlternationsPropertyMatch(propertyName, propertyMatches.toArray(new TypeMatch.PropertyMatch[propertyMatches.size()])));
                } else if (value != null) {
                    typeMatch.addPropertyMatch(propertyName, value);
                } else if (caseInsensitiveValue != null) {
                    typeMatch.addCaseInsensitiveMatch(propertyName, caseInsensitiveValue);
                } else {
                    typeMatch.addRegexMatch(propertyName, pattern);
                }
            } else if (Character.isDigit(ch) || ch == 45) {
                ArrayList<TypeMatch.NumberPropertyMatch> propertyMatches = null;
                Object number = this.parseNumber(ch);
                while (this.peek() == 124) {
                    this.read();
                    if (propertyMatches == null) {
                        propertyMatches = new ArrayList<TypeMatch.NumberPropertyMatch>();
                        TypeMatch typeMatch9 = typeMatch;
                        typeMatch9.getClass();
                        propertyMatches.add(typeMatch9.new TypeMatch.NumberPropertyMatch(propertyName, number));
                    }
                    number = this.parseNumber(this.read());
                    TypeMatch typeMatch10 = typeMatch;
                    typeMatch10.getClass();
                    propertyMatches.add(typeMatch10.new TypeMatch.NumberPropertyMatch(propertyName, number));
                }
                if (propertyMatches != null) {
                    TypeMatch typeMatch11 = typeMatch;
                    typeMatch11.getClass();
                    typeMatch.addAlternationsPropertyMatch(typeMatch11.new TypeMatch.AlternationsPropertyMatch(propertyName, propertyMatches.toArray(new TypeMatch.PropertyMatch[propertyMatches.size()])));
                } else {
                    typeMatch.addNumberPropertyMatch(propertyName, number);
                }
            } else if (Character.isAlphabetic(ch)) {
                Boolean value;
                if (ch == 116 || ch == 84 || ch == 121 || ch == 89) {
                    value = true;
                } else if (ch == 102 || ch == 70 || ch == 110 || ch == 78) {
                    value = false;
                } else {
                    if (ch == 101) {
                        ch = this.read();
                        String enumName = this.readAlphanumeric(ch);
                        typeMatch.addEnumMatch(propertyName, enumName);
                        return;
                    }
                    throw this.error("Invalid property value");
                }
                while (Character.isAlphabetic(this.peek())) {
                    this.read();
                }
                typeMatch.addPropertyMatch(propertyName, value);
            } else if (ch == 36) {
                String backReferenceGroup = this.parseBackreferenceGroupName();
                ch = this.peek();
                if (ch == 46) {
                    Integer brGroup = this.groupNames.get(backReferenceGroup);
                    Class<?> type = this.groupTypes.get(brGroup);
                    String backPropertyName = this.parseTypeName(this.read());
                    try {
                        Method method = type.getMethod(backPropertyName, new Class[0]);
                        typeMatch.addPropertyValueBackReference(propertyName, backReferenceGroup, method);
                    }
                    catch (NoSuchMethodException e) {
                        throw this.error(e.getLocalizedMessage());
                    }
                } else {
                    typeMatch.addSpanBackReference(propertyName, backReferenceGroup);
                }
            } else {
                throw this.error("Illegal property value");
            }
        }

        PatternSyntaxException error(String desc) {
            return new PatternSyntaxException(desc, this.expression, this.index);
        }

        int read() {
            return this.arr[this.index++];
        }

        int peekPastWhiteSpace() {
            int ch;
            while (Character.isWhitespace(ch = this.peek())) {
                this.read();
            }
            return ch;
        }

        int peek() {
            return this.arr[this.index];
        }

        int peekNext() {
            return this.arr[this.index + 1];
        }

        int skip() {
            char ch = this.arr[this.index + 1];
            this.index += 2;
            return ch;
        }

        void unread() {
            --this.index;
        }

        int next() {
            return this.arr[++this.index];
        }

        boolean accept(int ch) {
            if (this.arr[this.index] == ch) {
                ++this.index;
                return true;
            }
            return false;
        }

        boolean expect(int ch, String msg) {
            if (this.arr[this.index] != ch) {
                throw this.error(msg);
            }
            ++this.index;
            return true;
        }

        boolean consumePastWhiteSpace(int ch) {
            int peek = this.peekPastWhiteSpace();
            if (peek == ch) {
                this.read();
                return true;
            }
            return false;
        }
    }

    static class Chain {
        final Node head;
        final Node tail;

        Chain(Node single) {
            this.head = this.tail = single;
        }

        Chain(Node head, Node tail) {
            this.head = head;
            this.tail = tail;
        }
    }
}

