/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.biomedicus.framework;

import edu.umn.biomedicus.framework.LabelAliases;
import edu.umn.biomedicus.framework.SearchExpr;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SearchExprFactory {
    private final LabelAliases labelAliases;

    @Inject
    public SearchExprFactory(LabelAliases labelAliases) {
        this.labelAliases = labelAliases;
    }

    @Nonnull
    public SearchExpr parse(@Nonnull String expr) {
        return SearchExpr.parse(this.labelAliases, expr);
    }

    @Nonnull
    public SearchExpr readAndParse(@Nonnull String path, @Nonnull Charset charset) throws IOException {
        return SearchExpr.parse(this.labelAliases, new String(Files.readAllBytes(Paths.get(path, new String[0])), charset));
    }

    @Nonnull
    public SearchExpr readAndParse(@Nonnull String path) throws IOException {
        return this.readAndParse(path, Charset.defaultCharset());
    }
}

